/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.kernel.utils;

import java.util.HashSet;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public class UniqueIDUtils {
    private static int setMissingId(EObject object, int currentMaxId) {
        if (object instanceof IIdLabeled && ((IIdLabeled)object).getId() <= 0) {
            ((IIdLabeled)object).setId(++currentMaxId);
        }
        return currentMaxId;
    }

    public static int generateMissingIDs(EObject existingModel, int currentMaxId) {
        currentMaxId = UniqueIDUtils.setMissingId(existingModel, currentMaxId);
        TreeIterator i = existingModel.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            currentMaxId = UniqueIDUtils.setMissingId(eo, currentMaxId);
        }
        return currentMaxId;
    }

    public static boolean removeDuplicateIds(EObject existingModel) {
        HashSet<Integer> ids = new HashSet<Integer>();
        boolean removedDuplicateId = false;
        TreeIterator i = existingModel.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!(eo instanceof IIdLabeled)) continue;
            IIdLabeled element = (IIdLabeled)eo;
            int id = element.getId();
            if (ids.contains(id)) {
                element.setId(0);
                removedDuplicateId = true;
                continue;
            }
            ids.add(id);
        }
        return removedDuplicateId;
    }

    public static int getLargestID(EObject existingModel) {
        int max = 0;
        TreeIterator i = existingModel.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!(eo instanceof IIdLabeled) || ((IIdLabeled)eo).getId() <= max) continue;
            max = ((IIdLabeled)eo).getId();
        }
        return max;
    }

    public static void generateAllIDs(EObject existingModel) {
        int currentId = 0;
        TreeIterator i = existingModel.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!(eo instanceof IIdLabeled)) continue;
            ((IIdLabeled)eo).setId(++currentId);
        }
    }

    public static int prepareIDs(EObject object, EObject existingModel, int currentMaxId) {
        if (object == null) {
            return currentMaxId;
        }
        boolean needSmart = false;
        if (object instanceof IIdLabeled) {
            if (((IIdLabeled)object).getId() <= 0) {
                ((IIdLabeled)object).setId(++currentMaxId);
            } else {
                needSmart = true;
            }
        }
        TreeIterator i = object.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!(eo instanceof IIdLabeled)) continue;
            if (((IIdLabeled)eo).getId() <= 0) {
                ((IIdLabeled)eo).setId(++currentMaxId);
                continue;
            }
            needSmart = true;
        }
        if (needSmart) {
            EObject eo;
            HashSet<Integer> usedIDs = new HashSet<Integer>();
            TreeIterator i2 = existingModel.eAllContents();
            while (i2.hasNext()) {
                eo = (EObject)i2.next();
                if (!(eo instanceof IIdLabeled)) continue;
                usedIDs.add(((IIdLabeled)eo).getId());
            }
            if (object instanceof IIdLabeled && !usedIDs.add(((IIdLabeled)object).getId())) {
                int newId = ++currentMaxId;
                ((IIdLabeled)object).setId(newId);
                usedIDs.add(newId);
            }
            i = object.eAllContents();
            while (i.hasNext()) {
                eo = (EObject)i.next();
                if (!(eo instanceof IIdLabeled) || usedIDs.add(((IIdLabeled)eo).getId())) continue;
                int newId = ++currentMaxId;
                ((IIdLabeled)eo).setId(newId);
                usedIDs.add(newId);
            }
        }
        return currentMaxId;
    }

    public static void prepareUniqueID(EObject element, EObject context) {
        if (element instanceof IIdLabeled) {
            ITopLevelElement top = IPersistencyService.getInstance().getTopLevelElementFor(context);
            if (top == null) {
                EObject root = context;
                while (root.eContainer() != null) {
                    root = root.eContainer();
                }
                int id = 0;
                TreeIterator iter = root.eAllContents();
                while (iter.hasNext()) {
                    EObject o = (EObject)iter.next();
                    if (!(o instanceof IIdLabeled)) continue;
                    id = Math.max(id, ((IIdLabeled)o).getId());
                }
                ((IIdLabeled)element).setId(id + 1);
            } else {
                top.prepareIDs(element);
            }
        }
    }

    public static boolean hasMissingIDs(EObject existingModel) {
        TreeIterator i = existingModel.eAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!(eo instanceof IIdLabeled) || ((IIdLabeled)eo).getId() > 0) continue;
            return true;
        }
        return false;
    }

    public static void fixMissingIDs(EObject object, EObject existingModel) {
        EObject root = existingModel;
        while (root.eContainer() != null) {
            root = root.eContainer();
        }
        int maxID = UniqueIDUtils.getLargestID(root);
        if (maxID > 0) {
            UniqueIDUtils.generateMissingIDs(object, maxID);
        }
    }
}

