/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.soa.constraint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.soa.utils.SOAUtils;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class GlobalTopicConstraintChecker
extends ConstraintCheckerBase<Port> {
    public boolean isApplicable(Port port) {
        return port != null && SOAUtils.hasSOATopic((EObject)port);
    }

    public List<? extends IConstraintViolation<? extends EObject>> apply(Port soaPortToBeChecked) {
        ArrayList<ConstraintViolationBase<Port>> result = new ArrayList<ConstraintViolationBase<Port>>();
        List<Port> soaPorts = SOAUtils.getAllSOAPorts(soaPortToBeChecked.getComponent());
        List possiblyViolatedPorts = soaPorts.stream().filter(port2 -> port2 != soaPortToBeChecked && this.haveSameTopic((Port)port2, soaPortToBeChecked)).collect(Collectors.toList());
        LinkedList<Port> searchQueue = new LinkedList<Port>(Arrays.asList(soaPortToBeChecked));
        while (!searchQueue.isEmpty()) {
            Port currentPort = (Port)searchQueue.poll();
            Iterator portIterator = possiblyViolatedPorts.iterator();
            while (portIterator.hasNext()) {
                Port possiblyViolatedPort = (Port)portIterator.next();
                if (!this.haveValidTopicConnection(currentPort, possiblyViolatedPort)) continue;
                searchQueue.add(possiblyViolatedPort);
                portIterator.remove();
            }
            if (!possiblyViolatedPorts.isEmpty()) continue;
            return result;
        }
        for (Port violatedPort : possiblyViolatedPorts) {
            result.add(GlobalTopicConstraintChecker.createMultiLevelTopicViolation(soaPortToBeChecked, violatedPort));
        }
        return result;
    }

    private boolean haveSameTopic(Port port1, Port port2) {
        String topic1 = SOAUtils.getValidTopicName((IConnector)port1);
        String topic2 = SOAUtils.getValidTopicName((IConnector)port2);
        return topic1 != null && topic2 != null && topic1.equals(topic2);
    }

    private boolean haveValidTopicConnection(Port port1, Port port2) {
        boolean component2IsParentOfComponent1;
        Component component1 = port1.getComponent();
        Component component2 = port2.getComponent();
        Component parentOfComponent1 = component1.getParentComponent();
        Component parentOfComponent2 = component2.getParentComponent();
        boolean areOfSameType = SOAUtils.isPublisherPort((EObject)port1) && SOAUtils.isPublisherPort((EObject)port2) || SOAUtils.isSubscriberPort((EObject)port1) && SOAUtils.isSubscriberPort((EObject)port2);
        boolean haveSameParents = parentOfComponent1 == parentOfComponent2;
        boolean component1IsParentOfComponent2 = component1 == parentOfComponent2 && areOfSameType;
        boolean bl = component2IsParentOfComponent1 = component2 == parentOfComponent1 && areOfSameType;
        return haveSameParents || component1IsParentOfComponent2 || component2IsParentOfComponent1;
    }

    private static ConstraintViolationBase<Port> createMultiLevelTopicViolation(Port soaPort1, Port soaPort2) {
        Component component1 = soaPort1.getComponent();
        Component component2 = soaPort2.getComponent();
        return new ConstraintViolationBase((EObject)soaPort1, IConstraintViolation.ESeverity.ERROR, "The SOA port '" + soaPort1.getName() + "' [ID " + soaPort1.getId() + "] (of component '" + component1.getName() + "' [ID " + component1.getId() + "]) has the topic '" + SOAUtils.getValidTopicName((IConnector)soaPort1) + "', which is also used on another level by the SOA port '" + soaPort2.getName() + "' [ID " + soaPort2.getId() + "] (of component '" + component2.getName() + "' [ID " + component2.getId() + "]). Topic connections between different levels without a connecting path between their ports are not allowed.");
    }
}

