/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.soa.constraint;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.soa.utils.SOAUtils;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;

public class MissingTopicConstraintChecker
extends ConstraintCheckerBase<Port> {
    public boolean isApplicable(Port port) {
        return port != null && SOAUtils.isSOAPort((EObject)port);
    }

    public List<? extends IConstraintViolation<? extends EObject>> apply(Port soaPortToBeChecked) {
        String typeName;
        ArrayList<ConstraintViolationBase<Port>> result = new ArrayList<ConstraintViolationBase<Port>>();
        if (!SOAUtils.hasSOATopic((EObject)soaPortToBeChecked) && !(typeName = MissingTopicConstraintChecker.getNameOfUserDefinedType((IConnector)soaPortToBeChecked)).equals("Omitted")) {
            result.add(MissingTopicConstraintChecker.createMissingTopicViolation(soaPortToBeChecked));
        }
        return result;
    }

    private static ConstraintViolationBase<Port> createMissingTopicViolation(Port soaPort) {
        Component component = soaPort.getComponent();
        return new ConstraintViolationBase((EObject)soaPort, IConstraintViolation.ESeverity.WARNING, "The SOA port '" + soaPort.getName() + "' [ID " + soaPort.getId() + "] (of component '" + component.getName() + "' [ID " + component.getId() + "]) has no valid topic. For a valid topic the port needs to have a Structure as data type, which has the prefix 'topic_'.");
    }

    private static String getNameOfUserDefinedType(IConnector topicConnector) {
        TypeDefinition typeDefinition;
        IType portType;
        if (topicConnector instanceof Port && (portType = ((Port)topicConnector).getVariableType()) instanceof TDefinedType && (typeDefinition = ((TDefinedType)portType).getDef()) != null) {
            return typeDefinition.getName();
        }
        return "";
    }
}

