/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.soa.utils;

import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.soa.model.AF3SOAFactory;
import org.fortiss.af3.soa.model.PublisherPort;
import org.fortiss.af3.soa.model.SOAChannel;
import org.fortiss.af3.soa.model.SubscriberPort;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public class SOAModelElementFactory {
    public static SubscriberPort createSubscriberPort(String name, String comment, IType portType, IExpressionTerm initialValue) {
        SubscriberPort subscriberPort = AF3SOAFactory.eINSTANCE.createSubscriberPort();
        subscriberPort.setName(name);
        subscriberPort.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)subscriberPort);
        ComponentModelElementFactory.createPortSpecification((Port)subscriberPort, (IType)portType, (IExpressionTerm)initialValue);
        return subscriberPort;
    }

    public static SubscriberPort createSubscriberPort(String name, String comment) {
        return SOAModelElementFactory.createSubscriberPort(name, comment, (IType)ExpressionModelElementFactory.createUnboundDefinedType((String)"NaN"), (IExpressionTerm)ExpressionModelElementFactory.createNoVal());
    }

    public static PublisherPort createPublisherPort(String name, String comment, IType portType, IExpressionTerm initialValue) {
        PublisherPort publisherPort = AF3SOAFactory.eINSTANCE.createPublisherPort();
        publisherPort.setName(name);
        publisherPort.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)publisherPort);
        ComponentModelElementFactory.createPortSpecification((Port)publisherPort, (IType)portType, (IExpressionTerm)initialValue);
        return publisherPort;
    }

    public static PublisherPort createPublisherPort(String name, String comment) {
        return SOAModelElementFactory.createPublisherPort(name, comment, (IType)ExpressionModelElementFactory.createUnboundDefinedType((String)"NaN"), (IExpressionTerm)ExpressionModelElementFactory.createNoVal());
    }

    public static SOAChannel createSOAChannel() {
        return SOAModelElementFactory.createSOAChannel("", "");
    }

    public static SOAChannel createSOAChannel(String name, String comment) {
        SOAChannel channel = AF3SOAFactory.eINSTANCE.createSOAChannel();
        channel.setName(name);
        channel.setComment(comment);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)channel);
        return channel;
    }

    public static SOAChannel createConnectedSOAChannel(String name, String comment, IConnector source, IConnector target) {
        SOAChannel channel = SOAModelElementFactory.createSOAChannel(name, comment);
        channel.setInternalSource(source);
        channel.setInternalTarget(target);
        return channel;
    }
}

