/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.soa.utils;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.soa.model.PublisherPort;
import org.fortiss.af3.soa.model.SubscriberPort;
import org.fortiss.af3.task.model.Signal;
import org.fortiss.af3.task.model.TaskInputPort;
import org.fortiss.af3.task.model.TaskOutputPort;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.util.ComponentToTaskArchitectureTransformation;
import org.fortiss.af3.task.util.TaskModelElementFactory;

public class SOAToTaskArchitectureTransformation
extends ComponentToTaskArchitectureTransformation {
    protected TaskInputPort getEntityInputPort(InputPort inputPort, ComponentToTaskAllocationTable ca2ta) {
        EList taskInputPorts = ca2ta.getTaskInputPorts(inputPort);
        if (taskInputPorts.isEmpty()) {
            throw new RuntimeException("The SOA-to-task architecture transformation should map each logical input port to at least one task input port.");
        }
        return (TaskInputPort)taskInputPorts.get(0);
    }

    protected List<OutputPort> getComponentOutputPorts(InputPort inputPort, List<Component> components) {
        String typeName;
        IType inputPortType;
        if (inputPort instanceof SubscriberPort && (inputPortType = inputPort.getVariableType()) instanceof TDefinedType && (typeName = ExpressionUtils.getNameForType((Object)inputPortType)).startsWith("topic_")) {
            Predicate<OutputPort> hasSameType = p -> {
                IType outputPortType = p.getVariableType();
                return ExpressionUtils.isStructureType((IType)outputPortType) && ExpressionUtils.getNameForType((Object)outputPortType).equals(typeName);
            };
            return components.stream().flatMap(c -> c.getOutputPorts().stream().filter(hasSameType)).collect(Collectors.toList());
        }
        return super.getComponentOutputPorts(inputPort, components);
    }

    protected TaskOutputPort createEntityOutputPort(OutputPort outputPort) {
        String name = outputPort.getName();
        if (outputPort instanceof PublisherPort) {
            return TaskModelElementFactory.createTaskQueuingOutputPort((String)name);
        }
        return TaskModelElementFactory.createTaskSamplingOutputPort((String)name);
    }

    protected TaskInputPort createEntityInputPort(InputPort inputPort) {
        String name = inputPort.getName();
        if (inputPort instanceof SubscriberPort) {
            return TaskModelElementFactory.createTaskQueuingInputPort((String)name);
        }
        return TaskModelElementFactory.createTaskSamplingInputPort((String)name);
    }

    protected Signal createEntityConnection(TaskOutputPort taskOutputPort, TaskInputPort taskInputPort) {
        String signalName = "Signal " + taskOutputPort.getName() + "\u2192" + taskInputPort.getName();
        return TaskModelElementFactory.createSignal((TaskOutputPort)taskOutputPort, (TaskInputPort)taskInputPort, (String)signalName);
    }
}

