/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.soa.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.soa.model.PublisherPort;
import org.fortiss.af3.soa.model.SOAChannel;
import org.fortiss.af3.soa.model.SubscriberPort;
import org.fortiss.af3.soa.utils.SOAModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class SOAUtils {
    public static final String TOPIC_PREFIX = "topic_";
    public static final String TOPIC_OMITTED = "Omitted";

    public static boolean isSOAPort(EObject element) {
        return SOAUtils.isSubscriberPort(element) || SOAUtils.isPublisherPort(element);
    }

    public static boolean isSubscriberPort(EObject element) {
        return element instanceof SubscriberPort;
    }

    public static boolean isPublisherPort(EObject element) {
        return element instanceof PublisherPort;
    }

    public static boolean isSOATopic(EObject element) {
        return element instanceof Structure && ((Structure)element).getName().startsWith(TOPIC_PREFIX);
    }

    public static boolean hasSOATopic(EObject element) {
        if (element instanceof IConnector) {
            return SOAUtils.getValidTopic((IConnector)element) != null;
        }
        if (element instanceof IConnection) {
            return SOAUtils.getValidTopic((IConnection)element) != null;
        }
        return false;
    }

    public static boolean hasSOAPort(Component targetComponent) {
        for (IConnector connector : targetComponent.getConnectors()) {
            if (!SOAUtils.isSOAPort((EObject)connector)) continue;
            return true;
        }
        return false;
    }

    public static Structure getValidTopic(IConnector topicConnector) {
        TypeDefinition typeDefinition;
        IType portType;
        if ((topicConnector instanceof SubscriberPort || topicConnector instanceof PublisherPort) && (portType = ((Port)topicConnector).getVariableType()) instanceof TDefinedType && (typeDefinition = ((TDefinedType)portType).getDef()) != null && SOAUtils.isSOATopic((EObject)typeDefinition)) {
            return (Structure)typeDefinition;
        }
        return null;
    }

    public static Structure getValidTopic(IConnection topicConnection) {
        IConnector topicConnector = topicConnection.getSource();
        if (topicConnector != null) {
            return SOAUtils.getValidTopic(topicConnector);
        }
        return null;
    }

    public static String getValidTopicName(IConnector topicConnector) {
        Structure topic = SOAUtils.getValidTopic(topicConnector);
        if (topic != null) {
            return topic.getName().substring(TOPIC_PREFIX.length());
        }
        return null;
    }

    public static String getValidTopicName(IConnection topicConnection) {
        IConnector topicConnector = topicConnection.getSource();
        if (topicConnector != null) {
            return SOAUtils.getValidTopicName(topicConnector);
        }
        return null;
    }

    public static List<Structure> getAllDefinedValidTopics(EObject anyElement) {
        ArrayList<Structure> foundTopics = new ArrayList<Structure>();
        DataDictionary dataDictionary = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)anyElement, DataDictionary.class);
        if (dataDictionary != null) {
            for (Structure structure : dataDictionary.getStructures()) {
                if (!SOAUtils.isSOATopic((EObject)structure)) continue;
                foundTopics.add(structure);
            }
        }
        return foundTopics;
    }

    public static List<StructureMember> getTopicMembers(EObject elementConnectedToTopicMembers) {
        Structure topic = null;
        IConnector topicConnector = null;
        if (elementConnectedToTopicMembers instanceof Structure) {
            topic = (Structure)elementConnectedToTopicMembers;
        } else if (elementConnectedToTopicMembers instanceof IConnector) {
            topicConnector = (IConnector)elementConnectedToTopicMembers;
        } else if (elementConnectedToTopicMembers instanceof IConnection) {
            topicConnector = ((IConnection)elementConnectedToTopicMembers).getSource();
        }
        if (topicConnector != null && SOAUtils.isSOAPort((EObject)topicConnector)) {
            topic = SOAUtils.getValidTopic(topicConnector);
        }
        if (topic != null && SOAUtils.isSOATopic((EObject)topic)) {
            return topic.getMembers();
        }
        return null;
    }

    public static List<Port> getFilteredSOAPortsByTopic(List<IConnector> portList, String topicName, Class<? extends Port> portClass) {
        ArrayList<Port> foundSOAPorts = new ArrayList<Port>();
        for (IConnector connector : portList) {
            Port port;
            String portTopicName;
            if (!portClass.isInstance(connector) || (portTopicName = SOAUtils.getValidTopicName((IConnector)(port = (Port)connector))) == null || !portTopicName.equals(topicName)) continue;
            foundSOAPorts.add(port);
        }
        return foundSOAPorts;
    }

    public static List<IConnection> getVisibleSOAConnections(Component rootComponent) {
        ArrayList<IConnection> soaConnections = new ArrayList<IConnection>();
        List parentSubscriberPorts = LambdaUtils.filterList((Collection)rootComponent.getConnectors(), c -> SOAUtils.isSubscriberPort((EObject)c));
        List parentPublisherPorts = LambdaUtils.filterList((Collection)rootComponent.getConnectors(), c -> SOAUtils.isPublisherPort((EObject)c));
        ArrayList subscriberPorts = new ArrayList();
        ArrayList<IConnector> publisherPorts = new ArrayList<IConnector>();
        for (Component component : rootComponent.getSubComponents()) {
            subscriberPorts.addAll(LambdaUtils.filterList((Collection)component.getConnectors(), c -> SOAUtils.isSubscriberPort((EObject)c)));
            publisherPorts.addAll(LambdaUtils.filterList((Collection)component.getConnectors(), c -> SOAUtils.isPublisherPort((EObject)c)));
        }
        List targetPorts = Stream.concat(subscriberPorts.stream(), parentPublisherPorts.stream()).collect(Collectors.toList());
        for (IConnector targetPort : targetPorts) {
            String topicName = SOAUtils.getValidTopicName(targetPort);
            if (topicName == null) continue;
            List<Port> foundSourcePorts = SOAUtils.getFilteredSOAPortsByTopic(publisherPorts, topicName, PublisherPort.class);
            foundSourcePorts.addAll(SOAUtils.getFilteredSOAPortsByTopic(parentSubscriberPorts, topicName, SubscriberPort.class));
            for (Port sourcePort : foundSourcePorts) {
                SOAChannel topicConnection = SOAModelElementFactory.createConnectedSOAChannel(topicName, "", (IConnector)sourcePort, targetPort);
                if (topicConnection == null) continue;
                soaConnections.add((IConnection)topicConnection);
            }
        }
        return soaConnections;
    }

    public static List<IConnection> getAllSOAConnections(Component anyComponent) {
        ArrayList<IConnection> soaConnections = new ArrayList<IConnection>();
        for (Port publisherPort : SOAUtils.getAllPublisherPorts(anyComponent)) {
            for (Port subscriberPort : SOAUtils.getAllSubscriberPorts(anyComponent)) {
                SOAChannel topicConnection;
                String topicNameOfPublisher = SOAUtils.getValidTopicName((IConnector)publisherPort);
                String topicNameOfSubscriber = SOAUtils.getValidTopicName((IConnector)subscriberPort);
                if (topicNameOfPublisher == null || topicNameOfSubscriber == null || !topicNameOfPublisher.equals(topicNameOfSubscriber) || (topicConnection = SOAModelElementFactory.createConnectedSOAChannel(topicNameOfPublisher, "", (IConnector)publisherPort, (IConnector)subscriberPort)) == null) continue;
                soaConnections.add((IConnection)topicConnection);
            }
        }
        return soaConnections;
    }

    public static List<Port> getAllSOAPorts(Component anyComponent) {
        Component topComponent = anyComponent.getTopComponentParent();
        return SOAUtils.getAllSOAPortsRecursively(topComponent, new ArrayList<Class<? extends Port>>(Arrays.asList(PublisherPort.class, SubscriberPort.class)));
    }

    public static List<Port> getAllPublisherPorts(Component anyComponent) {
        Component topComponent = anyComponent.getTopComponentParent();
        return SOAUtils.getAllSOAPortsRecursively(topComponent, new ArrayList<Class<? extends Port>>(Arrays.asList(PublisherPort.class)));
    }

    public static List<Port> getAllSubscriberPorts(Component anyComponent) {
        Component topComponent = anyComponent.getTopComponentParent();
        return SOAUtils.getAllSOAPortsRecursively(topComponent, new ArrayList<Class<? extends Port>>(Arrays.asList(SubscriberPort.class)));
    }

    private static List<Port> getAllSOAPortsRecursively(Component currentTopComponent, List<Class<? extends Port>> portClassList) {
        ArrayList<Port> foundSOAPorts = new ArrayList<Port>();
        for (IConnector connector : currentTopComponent.getConnectors()) {
            if (!portClassList.stream().anyMatch(portClass -> portClass.isInstance(connector))) continue;
            foundSOAPorts.add((Port)connector);
        }
        for (Component subComponent : currentTopComponent.getSubComponents()) {
            foundSOAPorts.addAll(SOAUtils.getAllSOAPortsRecursively(subComponent, portClassList));
        }
        return foundSOAPorts;
    }
}

