/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.ui.configure;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.tooling.ext.variability.ui.editor.VariabilityEditorUtils;
import org.fortiss.variability.bind.BindUtils;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;
import org.fortiss.variability.util.Pair;

public class ConfigureVariantDialog
extends Dialog {
    protected VariantConfiguration varConfig;
    protected TreeViewer treeViewer;
    Label msgLabel;
    protected EContentAdapter contentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (ConfigureVariantDialog.this.treeViewer != null && ConfigureVariantDialog.this.treeViewer.getControl() != null && !ConfigureVariantDialog.this.treeViewer.getControl().isDisposed()) {
                ConfigureVariantDialog.this.treeViewer.refresh();
            } else if (ConfigureVariantDialog.this.varConfig != null) {
                ConfigureVariantDialog.this.varConfig.eAdapters().remove((Object)this);
            }
            ConfigureVariantDialog.this.updateMessage();
        }
    };

    public ConfigureVariantDialog(Shell parentShell, VariantConfiguration varConfig) {
        super(parentShell);
        this.varConfig = varConfig;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        parent.setLayout((Layout)new GridLayout(1, false));
        this.msgLabel = new Label(parent, 0);
        this.msgLabel.setSize(800, 25);
        this.msgLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.msgLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.updateMessage();
        this.treeViewer = new TreeViewer((Composite)ctrl, 65536);
        VariabilityEditorUtils.setUpVariantConfigurationTreeViewer(this.treeViewer, this.varConfig);
        this.treeViewer.setInput((Object)this.varConfig);
        this.treeViewer.expandAll();
        this.varConfig.eAdapters().add((Object)this.contentAdapter);
        return ctrl;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Configure Variant to be Generated");
    }

    public VariantConfiguration getVariantConfiguration() {
        return this.varConfig;
    }

    private void updateMessage() {
        if (this.varConfig != null) {
            Pair problem = BindUtils.checkVariantConfiguration((VariantConfiguration)this.varConfig);
            Button okButton = this.getButton(0);
            if (problem == null) {
                this.msgLabel.setText("");
                if (okButton != null) {
                    okButton.setEnabled(true);
                }
            } else {
                this.msgLabel.setText((String)problem.first);
                this.msgLabel.requestLayout();
                if (okButton != null) {
                    okButton.setEnabled(false);
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateMessage();
        return contents;
    }
}

