/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.variability.model.VariabilityModelElementFactory;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.configuration.AlternativeFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.CompositionalFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.IFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;
import org.fortiss.variability.util.VariabilityUtils;

public class AlternativeConfigurationEditingSupport
extends EditingSupport {
    private final VariantConfiguration variantConfiguration;
    TreeViewer viewer;
    Tree tree;

    public AlternativeConfigurationEditingSupport(VariantConfiguration variantConfiguration, TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.variantConfiguration = variantConfiguration;
        this.viewer = treeViewer;
        this.tree = treeViewer.getTree();
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof AlternativeFeatureConfiguration) {
            ComboBoxViewerCellEditor editor = new ComboBoxViewerCellEditor((Composite)this.getViewer().getControl());
            editor.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider());
            editor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider(){

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof AlternativeFeatureConfiguration) {
                        AbstractFeature feature = ((AlternativeFeatureConfiguration)inputElement).getFeatureReference();
                        if (!$assertionsDisabled && !(feature instanceof AbstractAlternativeFeature)) {
                            throw new AssertionError();
                        }
                        EList alternatives = ((AbstractAlternativeFeature)feature).getAlternatives();
                        ArrayList<String> r = new ArrayList<String>((Collection<String>)alternatives);
                        if (feature.isOptional()) {
                            r.add("None");
                        }
                        return r.toArray();
                    }
                    return new Object[0];
                }
            });
            editor.setInput(element);
            return editor;
        }
        return new CheckboxCellEditor((Composite)this.tree);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof AlternativeFeatureConfiguration) {
            AlternativeFeatureConfiguration afc = (AlternativeFeatureConfiguration)element;
            return afc.valueToString();
        }
        if (element instanceof IFeatureConfiguration) {
            return ((IFeatureConfiguration)element).isSelected();
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (value instanceof String) {
            this.setValueString(element, (String)value);
            return;
        }
        if (value instanceof AbstractFeature) {
            this.setValueForAbstractFeature(element, (AbstractFeature)value);
            return;
        }
        if (value instanceof Boolean) {
            this.setValueForBoolean(element, (Boolean)value);
            return;
        }
    }

    private void setValueForBoolean(Object element, final boolean value) {
        assert (element instanceof CompositionalFeatureConfiguration);
        final CompositionalFeatureConfiguration fc = (CompositionalFeatureConfiguration)element;
        if (this.isContainedInProject((EObject)fc)) {
            ICommandStackService.getInstance().runAsCommand((EObject)this.variantConfiguration, new Runnable(){

                @Override
                public void run() {
                    if (value) {
                        VariabilityUtils.selectFeatureConfiguration((CompositionalFeatureConfiguration)fc);
                        AlternativeConfigurationEditingSupport.this.expandNewElement((IFeatureConfiguration<?>)fc);
                    } else {
                        VariabilityUtils.checkAndDeselectFeatureConfiguration((CompositionalFeatureConfiguration)fc);
                    }
                }
            });
        } else if (value) {
            VariabilityUtils.selectFeatureConfiguration((CompositionalFeatureConfiguration)fc);
            this.expandNewElement((IFeatureConfiguration<?>)fc);
        } else {
            VariabilityUtils.checkAndDeselectFeatureConfiguration((CompositionalFeatureConfiguration)fc);
        }
    }

    private void setValueForAbstractFeature(Object element, final AbstractFeature value) {
        assert (element instanceof AlternativeFeatureConfiguration);
        final AlternativeFeatureConfiguration afc = (AlternativeFeatureConfiguration)element;
        if (this.isContainedInProject((EObject)this.variantConfiguration)) {
            ICommandStackService.getInstance().runAsCommand((EObject)this.variantConfiguration, new Runnable(){

                @Override
                public void run() {
                    IFeatureConfiguration altConf = VariabilityModelElementFactory.createFeatureConfigurationForFeature((AbstractFeature)value);
                    altConf.setSelected(true);
                    afc.setSelectedConfiguration(altConf);
                    afc.setSelected(true);
                    AlternativeConfigurationEditingSupport.this.expandNewElement((IFeatureConfiguration<?>)afc);
                }
            });
        } else {
            IFeatureConfiguration altConf = VariabilityModelElementFactory.createFeatureConfigurationForFeature((AbstractFeature)value);
            altConf.setSelected(true);
            afc.setSelectedConfiguration(altConf);
            afc.setSelected(true);
            this.expandNewElement((IFeatureConfiguration<?>)afc);
        }
    }

    private void setValueString(Object element, String value) {
        assert (value.equals("None"));
        assert (element instanceof AlternativeFeatureConfiguration);
        final AlternativeFeatureConfiguration afc = (AlternativeFeatureConfiguration)element;
        if (this.isContainedInProject((EObject)this.variantConfiguration)) {
            ICommandStackService.getInstance().runAsCommand((EObject)this.variantConfiguration, new Runnable(){

                @Override
                public void run() {
                    afc.setSelected(false);
                    afc.setSelectedConfiguration(null);
                }
            });
        } else {
            afc.setSelected(false);
            afc.setSelectedConfiguration(null);
        }
    }

    private boolean isContainedInProject(EObject eObj) {
        return IPersistencyService.getInstance().getTopLevelElementFor(eObj) != null;
    }

    private void expandNewElement(IFeatureConfiguration<?> newConf) {
        ArrayList<Object> expanded = new ArrayList<Object>();
        expanded.addAll(Arrays.asList(this.viewer.getExpandedElements()));
        expanded.add(newConf);
        this.viewer.setExpandedElements(expanded.toArray());
    }
}

