/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.fortiss.tooling.base.ui.editor.TreeViewerEditorBase;
import org.fortiss.tooling.ext.variability.ui.editor.AlternativesNamesEditingSupport;
import org.fortiss.tooling.ext.variability.ui.editor.PresenceConditionEditingSupportBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.tooling.kernel.ui.extension.base.ModelEditorBindingBase;
import org.fortiss.tooling.kernel.ui.presentation.ConstraintViolationAwareLabelProviderBase;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.util.EObjectSelectionUtils;
import org.fortiss.variability.model.IAlternativeVariationPoint;
import org.fortiss.variability.model.presence.IHasPresenceCondition;
import org.fortiss.variability.model.presence.PresenceCondition;

public class AlternativeVariationPointEditor
extends TreeViewerEditorBase<IAlternativeVariationPoint<?>> {
    protected TreeViewer createTreeViewer(Composite parent) {
        return new TreeViewer(parent);
    }

    protected void setupTreeViewer(TreeViewer treeViewer) {
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        treeViewer.setAutoExpandLevel(-1);
        treeViewer.setContentProvider((IContentProvider)new TreeContentProviderBase(){

            public Object[] getChildren(Object parentElement) {
                ArrayList ret = new ArrayList();
                if (parentElement instanceof IAlternativeVariationPoint) {
                    ret.addAll(((IAlternativeVariationPoint)parentElement).getAlternatives());
                }
                return ret.toArray();
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof AlternativeVariationPointEditor) {
                    IAlternativeVariationPoint avp = (IAlternativeVariationPoint)((AlternativeVariationPointEditor)((Object)inputElement)).getEditedObject();
                    return avp.getAlternatives().toArray();
                }
                if (inputElement instanceof IAlternativeVariationPoint) {
                    return ((IAlternativeVariationPoint)inputElement).getAlternatives().toArray();
                }
                return this.getElements(inputElement);
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EObject element;
                if (event.getSelection() instanceof IStructuredSelection && (element = EObjectSelectionUtils.getFirstElement((ISelection)event.getSelection())) != null) {
                    IModelEditorBindingService.getInstance().openInEditor(element);
                }
            }
        });
        TreeViewerColumn variantCol = new TreeViewerColumn(treeViewer, 0);
        variantCol.getColumn().setResizable(true);
        variantCol.getColumn().setText(this.getAlternativesColumnLabel());
        variantCol.getColumn().setWidth(400);
        variantCol.setLabelProvider((CellLabelProvider)new ModelElementLabelProvider());
        variantCol.setEditingSupport((EditingSupport)new AlternativesNamesEditingSupport((ColumnViewer)treeViewer));
        TreeViewerColumn restCol = new TreeViewerColumn(treeViewer, 0);
        restCol.getColumn().setResizable(true);
        restCol.getColumn().setText(this.getPresenceConditionColumnLabel());
        restCol.getColumn().setWidth(400);
        restCol.setLabelProvider((CellLabelProvider)new ConstraintViolationAwareLabelProviderBase(){

            public String getText(Object element) {
                PresenceCondition pc;
                if (element instanceof IHasPresenceCondition && (pc = ((IHasPresenceCondition)element).getPresenceCondition()) != null) {
                    return pc.getStringRepresentation();
                }
                return "";
            }

            protected Image getBaseImage(Object element) {
                return this.getFallbackImage(element).createImage();
            }

            protected Collection<IConstraintViolation<?>> getViolationsForObject(Object object) {
                if (object instanceof IHasPresenceCondition) {
                    return super.getViolationsForObject((Object)((IHasPresenceCondition)object).getPresenceCondition());
                }
                return super.getViolationsForObject(object);
            }
        });
        restCol.setEditingSupport((EditingSupport)new PresenceConditionEditingSupportBase((ColumnViewer)treeViewer, (DataBindingContext)this.dbc, this.editedObject){

            @Override
            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)treeViewer);
    }

    protected String getPresenceConditionColumnLabel() {
        return "Presence Conditions";
    }

    protected String getAlternativesColumnLabel() {
        return "Alternatives";
    }

    public static class AlternativeVariationPointEditorBinding
    extends ModelEditorBindingBase<IAlternativeVariationPoint<?>> {
        public Class<? extends IEditorPart> getEditorClass() {
            return AlternativeVariationPointEditor.class;
        }

        public Class<? extends IEditorPart> getEditorClass(IAlternativeVariationPoint<?> object) {
            return this.getEditorClass();
        }

        public String getLabel(IAlternativeVariationPoint<?> object) {
            return object.getName();
        }
    }
}

