/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.ui.editor;

import java.util.List;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.fortiss.tooling.ext.variability.ui.VariabilityUIActivator;
import org.fortiss.tooling.ext.variability.ui.editor.AlternativeConfigurationEditingSupport;
import org.fortiss.tooling.ext.variability.ui.editor.CheckBoxLabelProvider;
import org.fortiss.tooling.ext.variability.ui.editor.VariantConfigurationLabelProvider;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.variability.bind.BindUtils;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.configuration.AlternativeFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.CompositionalFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.IFeatureConfiguration;
import org.fortiss.variability.model.features.configuration.VariantConfiguration;
import org.fortiss.variability.util.Pair;

public class VariabilityEditorUtils {
    private static final int FEATURE_SELECTION_COLUMN_WIDTH = 400;
    private static final int FEATURE_COLUMN_WIDTH = 400;
    public static final int CONFIGURATION_TREETABLE_WIDTH = 800;

    public static void setUpVariantConfigurationTreeViewer(TreeViewer treeViewer, final VariantConfiguration varConfig) {
        treeViewer.setContentProvider((IContentProvider)new TreeContentProviderBase(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof CompositionalFeatureConfiguration) {
                    return ((CompositionalFeatureConfiguration)parentElement).getSubConfigurations().toArray();
                }
                if (parentElement instanceof AlternativeFeatureConfiguration) {
                    AlternativeFeatureConfiguration afc = (AlternativeFeatureConfiguration)parentElement;
                    IFeatureConfiguration featureConfiguration = afc.getSelectedConfiguration();
                    if (featureConfiguration instanceof CompositionalFeatureConfiguration) {
                        return ((CompositionalFeatureConfiguration)featureConfiguration).getSubConfigurations().toArray();
                    }
                    if (featureConfiguration instanceof AlternativeFeatureConfiguration) {
                        return new Object[]{featureConfiguration};
                    }
                }
                return new Object[0];
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider());
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        GridDataFactory.swtDefaults().span(1, 5).grab(true, true).align(4, 4).applyTo((Control)treeViewer.getTree());
        TreeViewerColumn featureCol = new TreeViewerColumn(treeViewer, 0);
        featureCol.getColumn().setResizable(true);
        featureCol.getColumn().setText("Features");
        featureCol.getColumn().setWidth(400);
        featureCol.setLabelProvider((CellLabelProvider)new VariantConfigurationLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer);
        treeViewer.expandAll();
        TreeViewerColumn selectionCol = new TreeViewerColumn(treeViewer, 0);
        selectionCol.getColumn().setResizable(true);
        selectionCol.getColumn().setText("Selection");
        selectionCol.getColumn().setWidth(400);
        selectionCol.setLabelProvider((CellLabelProvider)new CheckBoxLabelProvider(){

            public String getText(Object element) {
                if (element instanceof AlternativeFeatureConfiguration) {
                    AlternativeFeatureConfiguration afc = (AlternativeFeatureConfiguration)element;
                    return afc.valueToString();
                }
                if (VariabilityEditorUtils.isMandatoryFeatureConfig(element)) {
                    return " (non-optional)";
                }
                return "";
            }

            public Color getBackground(Object element) {
                if (element instanceof IFeatureConfiguration) {
                    AbstractFeature referencedFeature = ((IFeatureConfiguration)element).getFeatureReference();
                    Pair checkResult = BindUtils.checkVariantConfiguration((VariantConfiguration)varConfig);
                    if (checkResult != null && ((List)checkResult.second).contains(referencedFeature)) {
                        return Display.getCurrent().getSystemColor(3);
                    }
                    if (VariabilityEditorUtils.isMandatoryFeatureConfig(element)) {
                        return Display.getCurrent().getSystemColor(15);
                    }
                }
                return super.getBackground(element);
            }

            @Override
            public Image getImage(Object element) {
                if (VariabilityEditorUtils.isMandatoryFeatureConfig(element)) {
                    if (((CompositionalFeatureConfiguration)element).isSelected()) {
                        return VariabilityUIActivator.getImageDescriptor("icons/checkbox_enabled_greyed.gif").createImage();
                    }
                    LoggingUtils.warning((Plugin)VariabilityUIActivator.getDefault(), (String)"Mandatory feature is not selected in FeatureConfigurationDialog!");
                    return VariabilityUIActivator.getImageDescriptor("icons/checkbox_disabled_greyed.gif").createImage();
                }
                return super.getImage(element);
            }
        });
        selectionCol.setEditingSupport((EditingSupport)new AlternativeConfigurationEditingSupport(varConfig, treeViewer));
    }

    private static boolean isMandatoryFeatureConfig(Object config) {
        return config instanceof CompositionalFeatureConfiguration && !((AbstractCompositionalFeature)((CompositionalFeatureConfiguration)config).getFeatureReference()).isOptional();
    }
}

