/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.variability.ui.properties;

import java.util.List;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fortiss.tooling.base.ui.dialog.ElementTreeSingleSelectDialog;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.extension.base.PropertySectionBase;
import org.fortiss.tooling.kernel.ui.presentation.ModelElementLabelProvider;
import org.fortiss.variability.model.features.AbstractCrossFeatureConstraint;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.CrossFeatureConstraintType;
import org.fortiss.variability.util.VariabilityUtils;

public class CrossFeatureConstraintPropertySectionBase
extends PropertySectionBase {
    ComboViewer typeCombo;
    TableViewer targetFeatureViewer;
    AbstractCrossFeatureConstraint constraint;

    protected void setSectionInput(Object input) {
        if (input instanceof AbstractCrossFeatureConstraint) {
            this.constraint = (AbstractCrossFeatureConstraint)input;
            if (this.typeCombo != null) {
                this.typeCombo.setInput((Object)this.constraint);
                this.typeCombo.setSelection((ISelection)new StructuredSelection((Object)this.constraint.getType()));
            }
            if (this.targetFeatureViewer != null) {
                this.targetFeatureViewer.setInput((Object)this.constraint);
            }
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createTypeCombo();
        this.createTargetFeatureSelection();
    }

    protected void createTypeCombo() {
        this.typeCombo = this.createFormComboViewer("Constraint Type");
        this.typeCombo.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                return new Object[]{CrossFeatureConstraintType.REQUIRES, CrossFeatureConstraintType.EXCLUDES};
            }
        });
        this.typeCombo.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider());
        this.typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss;
                if (event.getSelection() instanceof StructuredSelection && (ss = (StructuredSelection)event.getSelection()).getFirstElement() instanceof CrossFeatureConstraintType) {
                    final CrossFeatureConstraintType newType = (CrossFeatureConstraintType)ss.getFirstElement();
                    if (CrossFeatureConstraintPropertySectionBase.this.constraint.getType() != newType) {
                        ICommandStackService.getInstance().runAsCommand((EObject)CrossFeatureConstraintPropertySectionBase.this.constraint, new Runnable(){

                            @Override
                            public void run() {
                                (this).CrossFeatureConstraintPropertySectionBase.this.constraint.setType(newType);
                            }
                        });
                    }
                }
            }
        });
    }

    protected void createTargetFeatureSelection() {
        final Composite featureComposite = new Composite(this.composite, 0);
        featureComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)featureComposite);
        this.targetFeatureViewer = new TableViewer(featureComposite, 0x800000);
        this.targetFeatureViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                AbstractFeature f;
                if (inputElement instanceof AbstractCrossFeatureConstraint && (f = ((AbstractCrossFeatureConstraint)inputElement).getTarget()) != null) {
                    return new Object[]{f};
                }
                return new Object[0];
            }
        });
        this.targetFeatureViewer.setLabelProvider((IBaseLabelProvider)new ModelElementLabelProvider());
        this.targetFeatureViewer.setInput((Object)this.constraint);
        Button selectButton = this.getWidgetFactory().createButton(featureComposite, "...", 0);
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject selectedElement;
                List features = VariabilityUtils.getAllLegalConstraintTargets((AbstractCrossFeatureConstraint)CrossFeatureConstraintPropertySectionBase.this.constraint);
                ElementTreeSingleSelectDialog dialog = new ElementTreeSingleSelectDialog(featureComposite.getShell(), features, null, (ITreeContentProvider)new TreeContentProviderBase(){

                    public Object[] getChildren(Object parentElement) {
                        return new Object[0];
                    }
                }, (ILabelProvider)new ModelElementLabelProvider(), null);
                if (dialog.open() == 0 && (selectedElement = (EObject)dialog.getSelectedElement()) instanceof AbstractFeature) {
                    ICommandStackService.getInstance().runAsCommand((EObject)CrossFeatureConstraintPropertySectionBase.this.constraint, new Runnable(){

                        @Override
                        public void run() {
                            (this).CrossFeatureConstraintPropertySectionBase.this.constraint.setTarget((AbstractFeature)selectedElement);
                            (this).CrossFeatureConstraintPropertySectionBase.this.targetFeatureViewer.refresh();
                        }
                    });
                }
            }
        });
        GridData layoutData = new GridData(4, 4, true, false, 1, 1);
        layoutData.heightHint = selectButton.getSize().y;
        this.targetFeatureViewer.getTable().setLayoutData((Object)layoutData);
        this.createFormEntry((Control)featureComposite, "Target Feature");
    }
}

