/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.ui;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.sysml.AF3SysMLExtractor;
import org.fortiss.af3.sysml.ui.AF3SysMLUIActivator;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public abstract class SysMLExportAction
extends Action {
    protected final EList<IProjectRootElement> viewpointElements;
    protected final FileProject fp;
    protected final String toolMode;
    protected final String iconFileName;

    public SysMLExportAction(String text, String toolMode, String iconFileName, FileProject fp, EList<IProjectRootElement> viewpointElements) {
        super(text, AF3SysMLUIActivator.getImageDescriptor("icons/" + iconFileName));
        this.viewpointElements = viewpointElements;
        this.fp = fp;
        this.toolMode = toolMode;
        this.iconFileName = iconFileName;
    }

    public void run() {
        Shell composite = Display.getCurrent().getActiveShell();
        String filename = this.openFileDialog(composite, this.toolMode);
        if (filename == null) {
            return;
        }
        File file = new File(filename);
        if (file.exists() && !MessageUtilsExtended.askQuestionInUIThread((String)"File exists", (String)("The selected file \"" + filename + "\" already exists. Overwrite?"))) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintStream printStream = new PrintStream(filename);){
                AF3SysMLExtractor extractor = new AF3SysMLExtractor(this.fp, this.viewpointElements);
                String sysmlFile = extractor.transformFileProjectToSysML(this.toolMode);
                printStream.println(sysmlFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LoggingUtils.showError((String)("Unable to save the SysML architecture file. " + ex.getMessage()));
        }
    }

    private String openFileDialog(Shell shell, String toolMode) {
        FileDialog fileChooser = new FileDialog(shell, 8192);
        String fileType = toolMode.equals("EA") || toolMode.equals("MagicDraw") ? "XMI" : "UML";
        String fileExtension = fileType.equals("XMI") ? ".xmi" : ".uml";
        fileChooser.setText(fileType + " SysML Architecture");
        fileChooser.setFilterExtensions(new String[]{"*" + fileExtension});
        fileChooser.setFilterNames(new String[]{fileType + " SysML Architecture (" + fileExtension + ")"});
        return fileChooser.open();
    }
}

