/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.sysml.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.function.model.FunctionArchitecture;
import org.fortiss.af3.function.model.allocation.FunctionToComponentAllocationTable;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.sysml.ui.AF3SysMLUIActivator;
import org.fortiss.af3.task.model.TaskArchitecture;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuMultiSelectionContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import subMenuToolEntries.EnterpriseArchitectExport;
import subMenuToolEntries.MagicDrawExport;
import subMenuToolEntries.PapyrusExport;

public class SysMLExportMenu
implements IContextMenuMultiSelectionContributor {
    public List<IContributionItem> getContributedItems(List<EObject> selection, ContextMenuContextProvider contextProvider) {
        if (selection == null || selection.isEmpty()) {
            return Collections.emptyList();
        }
        List fileProjects = selection.stream().map(s -> this.getFileProjectForEObject((EObject)s)).collect(Collectors.toList());
        if (fileProjects.stream().distinct().count() > 1L || !this.isValidSelection(selection)) {
            return Collections.emptyList();
        }
        FileProject fp = (FileProject)fileProjects.get(0);
        EList<IProjectRootElement> rootElementList = this.collectRootElements(selection);
        MenuManager subMenu = new MenuManager();
        subMenu.setMenuText("SysML Export");
        subMenu.setImageDescriptor(this.getExportIcon("SysMLIcon.png"));
        subMenu.add((IContributionItem)new ActionContributionItem((IAction)new EnterpriseArchitectExport(fp, rootElementList)));
        subMenu.add((IContributionItem)new ActionContributionItem((IAction)new PapyrusExport(fp, rootElementList)));
        subMenu.add((IContributionItem)new ActionContributionItem((IAction)new MagicDrawExport(fp, rootElementList)));
        ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
        contributionItems.add((IContributionItem)subMenu);
        return contributionItems;
    }

    private FileProject getFileProjectForEObject(EObject object) {
        if (object instanceof FileProject) {
            return (FileProject)object;
        }
        return (FileProject)EcoreUtils.getFirstParentWithType((EObject)object, FileProject.class);
    }

    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        return this.getContributedItems(Arrays.asList(selection), contextProvider);
    }

    public String getMenuSectionID() {
        return null;
    }

    private boolean isValidSelection(List<EObject> selection) {
        EList dds = EcoreUtils.pickInstanceOf(DataDictionary.class, selection);
        EList cas = EcoreUtils.pickInstanceOf(ComponentArchitecture.class, selection);
        EList tas = EcoreUtils.pickInstanceOf(TaskArchitecture.class, selection);
        EList pas = EcoreUtils.pickInstanceOf(PlatformArchitecture.class, selection);
        EList funs = EcoreUtils.pickInstanceOf(FunctionArchitecture.class, selection);
        EList allocs = EcoreUtils.pickInstanceOf(AllocationTableCollection.class, selection);
        if (dds.size() > 1 || cas.size() > 1 || tas.size() > 1 || pas.size() > 1 || funs.size() > 1 || allocs.size() > 1) {
            return false;
        }
        if (dds.isEmpty() && cas.isEmpty() && tas.isEmpty() && pas.isEmpty() && funs.isEmpty() && allocs.isEmpty()) {
            return false;
        }
        if (!allocs.isEmpty()) {
            return this.checkAllocationTableValidity((AllocationTableCollection)allocs.get(0), (List<FunctionArchitecture>)funs, (List<ComponentArchitecture>)cas, (List<TaskArchitecture>)tas, (List<PlatformArchitecture>)pas);
        }
        return true;
    }

    private boolean checkAllocationTableValidity(AllocationTableCollection at, List<FunctionArchitecture> funs, List<ComponentArchitecture> cas, List<TaskArchitecture> tas, List<PlatformArchitecture> pas) {
        for (AllocationTable table : at.getAllocationTables()) {
            if (table.getAllocationEntries().isEmpty()) continue;
            if (table instanceof FunctionToComponentAllocationTable && (funs.isEmpty() || cas.isEmpty())) {
                return false;
            }
            if (table instanceof ComponentToTaskAllocationTable && (cas.isEmpty() || tas.isEmpty())) {
                return false;
            }
            if (!(table instanceof TaskToExecutionUnitAllocationTable) || !tas.isEmpty() && !pas.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private EList<IProjectRootElement> collectRootElements(List<EObject> selection) {
        BasicEList rootElementList = new BasicEList();
        this.addIfNotEmpty((EList<IProjectRootElement>)rootElementList, (List<?>)EcoreUtils.pickInstanceOf(DataDictionary.class, selection));
        this.addIfNotEmpty((EList<IProjectRootElement>)rootElementList, (List<?>)EcoreUtils.pickInstanceOf(ComponentArchitecture.class, selection));
        this.addIfNotEmpty((EList<IProjectRootElement>)rootElementList, (List<?>)EcoreUtils.pickInstanceOf(TaskArchitecture.class, selection));
        this.addIfNotEmpty((EList<IProjectRootElement>)rootElementList, (List<?>)EcoreUtils.pickInstanceOf(PlatformArchitecture.class, selection));
        this.addIfNotEmpty((EList<IProjectRootElement>)rootElementList, (List<?>)EcoreUtils.pickInstanceOf(FunctionArchitecture.class, selection));
        this.addIfNotEmpty((EList<IProjectRootElement>)rootElementList, (List<?>)EcoreUtils.pickInstanceOf(AllocationTableCollection.class, selection));
        return rootElementList;
    }

    private void addIfNotEmpty(EList<IProjectRootElement> list, List<?> ele) {
        if (!ele.isEmpty()) {
            list.add((Object)((IProjectRootElement)ele.get(0)));
        }
    }

    protected ImageDescriptor getExportIcon(String fileName) {
        return AF3SysMLUIActivator.getImageDescriptor("icons/" + fileName);
    }
}

