/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.complexdata;

import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.fortiss.af3.expression.language.TypeChecker;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.terms.DefinedConst;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataStructure;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataTreeContentProvider;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataTreeEditingSupport;
import org.fortiss.af3.expression.utils.DataDictionaryUtils;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

@Deprecated
public class ComplexDataDialog
extends TitleAreaDialog {
    private boolean isInitialized = false;
    private EMFDataBindingContext dbc;
    private DataDictionary dictionary;
    private ComplexDataStructure node;
    private String title;
    private String message;
    private boolean editable;
    private CellLabelProvider nameProvider;
    private CellLabelProvider valueProvider;
    private CellLabelProvider typeProvider;
    private CellLabelProvider infoProvider;
    private ViewerComparator comparator;

    public ComplexDataDialog(Shell shell, EMFDataBindingContext dbc, String title, String message, DataDictionary dictionary, IType basetype, IExpressionTerm value, boolean editable, boolean isInitialized) {
        super(shell);
        this.title = title;
        this.message = message;
        this.dbc = dbc;
        this.dictionary = dictionary;
        this.node = new ComplexDataStructure(null, "", basetype, value);
        this.editable = editable;
        this.isInitialized = isInitialized;
        this.setBlockOnOpen(true);
        this.initialize();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        super.setTitle(this.title);
        if (!this.isInitialized) {
            super.setMessage(this.message);
        } else {
            super.setMessage(this.message, 2);
        }
        TreeViewer treeViewer = new TreeViewer(container, 2048);
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        TreeColumn nameColumn = new TreeColumn(treeViewer.getTree(), 16384);
        nameColumn.setWidth(100);
        nameColumn.setText("Name");
        TreeViewerColumn nameViewerColumn = new TreeViewerColumn(treeViewer, nameColumn);
        nameViewerColumn.setLabelProvider(this.nameProvider);
        TreeColumn valueColumn = new TreeColumn(treeViewer.getTree(), 16384);
        valueColumn.setWidth(100);
        valueColumn.setText("Value");
        TreeViewerColumn valueViewerColumn = new TreeViewerColumn(treeViewer, valueColumn);
        valueViewerColumn.setLabelProvider(this.valueProvider);
        TreeColumn typeColumn = new TreeColumn(treeViewer.getTree(), 16384);
        typeColumn.setWidth(100);
        typeColumn.setText("Type");
        TreeViewerColumn typeViewerColumn = new TreeViewerColumn(treeViewer, typeColumn);
        typeViewerColumn.setLabelProvider(this.typeProvider);
        TreeColumn infoColumn = new TreeColumn(treeViewer.getTree(), 16384);
        infoColumn.setWidth(100);
        infoColumn.setText("Info");
        TreeViewerColumn infoViewerColumn = new TreeViewerColumn(treeViewer, infoColumn);
        infoViewerColumn.setLabelProvider(this.infoProvider);
        treeViewer.setContentProvider((IContentProvider)new ComplexDataTreeContentProvider((EObject)this.dictionary));
        treeViewer.setInput((Object)this.node);
        treeViewer.setComparator(this.comparator);
        treeViewer.expandAll();
        if (this.editable) {
            valueViewerColumn.setEditingSupport((EditingSupport)new ComplexDataTreeEditingSupport((ColumnViewer)treeViewer, this.dbc, (EObject)this.dictionary));
        }
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void setComparator(ViewerComparator comparator) {
        this.comparator = comparator;
    }

    public void setNameProvider(CellLabelProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    public void setValueProvider(CellLabelProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void setTypeProvider(CellLabelProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public void setInfoProvider(CellLabelProvider infoProvider) {
        this.infoProvider = infoProvider;
    }

    private IExpressionTerm getExpression() {
        return this.node.getValue();
    }

    private void initialize() {
        this.setNameProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ComplexDataStructure node = (ComplexDataStructure)cell.getElement();
                cell.setText(node.getName());
            }
        });
        this.setValueProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ComplexDataStructure node = (ComplexDataStructure)cell.getElement();
                if (node.getValue() != null) {
                    if (node.getValue() instanceof StructureMemberConst) {
                        if (((StructureMemberConst)node.getValue()).getValue() != null) {
                            cell.setText(((StructureMemberConst)node.getValue()).getValue().toString());
                        } else {
                            cell.setText("");
                        }
                    } else {
                        cell.setText(node.getValue().toString());
                    }
                } else {
                    cell.setText("");
                }
            }
        });
        this.setTypeProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ComplexDataStructure node = (ComplexDataStructure)cell.getElement();
                if (node.getType() != null) {
                    cell.setText(node.getType().toString());
                } else {
                    cell.setText("");
                }
            }
        });
        this.setInfoProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                ComplexDataStructure node = (ComplexDataStructure)cell.getElement();
                if (node.getType() == null) {
                    cell.setText("missing type definition");
                    return;
                }
                if (node.getValue() == null) {
                    cell.setText("No Value");
                    return;
                }
                IExpressionTerm testValue = node.getValue();
                if (testValue instanceof StructureMemberConst) {
                    testValue = ((StructureMemberConst)testValue).getValue();
                }
                if (testValue instanceof DefinedConst) {
                    cell.setText("NoVal is not allowed");
                    return;
                }
                if (testValue == null) {
                    cell.setText("No Value");
                    return;
                }
                TypeChecker tc = new TypeChecker();
                if (!tc.typecheck((ITerm)testValue, node.getType(), (EObject)ComplexDataDialog.this.dictionary).isOK()) {
                    cell.setText("error type");
                    return;
                }
                cell.setText("");
            }
        });
        this.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                ComplexDataStructure N1 = (ComplexDataStructure)e1;
                ComplexDataStructure N2 = (ComplexDataStructure)e2;
                return N1.getName().compareTo(N2.getName());
            }
        });
    }

    public static IExpressionTerm openCDD(Shell shell, String title, String message, EObject eobj, IType baseType, IExpressionTerm value, boolean editable) {
        return ComplexDataDialog.openCDD(shell, new EMFDataBindingContext(), title, message, eobj, baseType, value, editable);
    }

    public static IExpressionTerm openCDD(Shell shell, EMFDataBindingContext dbc, String title, String message, EObject eobj, IType baseType, IExpressionTerm value, boolean editable) {
        ComplexDataDialog dialog;
        DataDictionary dictionary_ = DataDictionaryUtils.findDataDictionary((EObject)eobj);
        IExpressionTerm complexData = (IExpressionTerm)EcoreUtils.copy((EObject)value);
        IType baseType_ = (IType)EcoreUtils.copy((EObject)baseType);
        Object dialogMessage = message;
        boolean initialize = false;
        if (!ExpressionUtils.fastCheckComplexDataType((IExpressionTerm)complexData, (IType)baseType_, (EObject)dictionary_)) {
            if (!editable) {
                MessageDialog.openError((Shell)shell, (String)"Initialization error", (String)"Complex data does not suit the defined type. No value can be shown.");
                return null;
            }
            complexData = ExpressionUtils.createDefaultConst((IType)baseType_, (EObject)dictionary_);
            dialogMessage = "Warning : Variables of " + (String)dialogMessage + " are initialized with default values! Click cancel to undo the changes.";
            initialize = true;
        }
        if ((dialog = new ComplexDataDialog(shell, dbc, title, (String)dialogMessage, dictionary_, baseType_, complexData, editable, initialize)).open() == 0) {
            return dialog.getExpression();
        }
        return null;
    }
}

