/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.complexdata;

import java.util.ArrayList;
import org.conqat.ide.commons.ui.selection.SelectionUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.BoolTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.terms.ArrayConst;
import org.fortiss.af3.expression.model.terms.BoolConst;
import org.fortiss.af3.expression.model.terms.DefinedConst;
import org.fortiss.af3.expression.model.terms.DoubleConst;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.IntConst;
import org.fortiss.af3.expression.model.terms.StructureConst;
import org.fortiss.af3.expression.model.terms.StructureMemberConst;
import org.fortiss.af3.expression.model.terms.TermsPackage;
import org.fortiss.af3.expression.model.terms.UserdefinedFunction;
import org.fortiss.af3.expression.model.terms.impl.FunctionCallStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.UserdefinedFunctionStaticImpl;
import org.fortiss.af3.expression.ui.complexdata.ComplexDataStructure;
import org.fortiss.af3.expression.ui.databinding.convert.ITermToStringConverter;
import org.fortiss.af3.expression.ui.databinding.convert.StringToIExpressionTermConverter;
import org.fortiss.af3.expression.ui.databinding.validate.StringToIExpressionTermWithTypeCheckValidatorBase;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.expression.utils.ExpressionUtils;
import org.fortiss.af3.project.model.typesystem.IFunction;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.af3.project.model.typesystem.TypesystemPackage;
import org.fortiss.af3.project.utils.TypeScopeUtils;
import org.fortiss.tooling.kernel.ui.databinding.AbstractTextCellDatabindingEditingSupport;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;

@Deprecated
public class ComplexDataTreeEditingSupport
extends AbstractTextCellDatabindingEditingSupport {
    private EObject context;

    public ComplexDataTreeEditingSupport(ColumnViewer columnViewer, EMFDataBindingContext dbc, EObject context) {
        super(columnViewer, (DataBindingContext)dbc);
        this.context = context;
    }

    protected boolean canEdit(Object element) {
        ComplexDataStructure node = (ComplexDataStructure)element;
        if (node.getType() == null) {
            if (MessageDialog.openConfirm((Shell)this.getViewer().getControl().getParent().getShell(), (String)"Error:Missing definition ", (String)"This value will be removed. Do you want to delete the value?")) {
                this.removeChild(node.getParent().getValue(), node.getValue());
                this.getViewer().refresh();
                ((TreeViewer)this.getViewer()).expandAll();
            }
            return false;
        }
        ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)node.getType(), (EObject)this.context);
        if (typedef instanceof Structure) {
            return false;
        }
        if (typedef instanceof Array) {
            return false;
        }
        if (!this.fastCheckComplexDataTypeUnwrap(node.getValue(), node.getType(), node.getParent().getType(), this.context)) {
            this.fix(node, node.getParent(), this.context);
        }
        ((TreeViewer)this.getViewer()).expandAll();
        return true;
    }

    protected CellEditor createCellEditor(ColumnViewer viewer) {
        ComplexDataStructure element = (ComplexDataStructure)SelectionUtils.checkAndPickFirstSafe((ISelection)viewer.getSelection(), ComplexDataStructure.class);
        ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)element.getType(), (EObject)this.context);
        if (typedef instanceof Enumeration) {
            ComboBoxViewerCellEditor comboBoxViewerCellEditor = new ComboBoxViewerCellEditor((Composite)viewer.getControl(), 8);
            comboBoxViewerCellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            comboBoxViewerCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof FunctionCall) {
                        return ((FunctionCall)element).toString();
                    }
                    if (element instanceof UserdefinedFunction) {
                        return FunctionCallStaticImpl.create((IFunction)((IFunction)element)).toString();
                    }
                    return "";
                }
            });
            EList members = ((Enumeration)typedef).getMembers();
            if (element.getValue() instanceof FunctionCall) {
                ArrayList<UserdefinedFunction> functions = new ArrayList<UserdefinedFunction>();
                for (EnumerationMember member : members) {
                    functions.add(UserdefinedFunctionStaticImpl.create((String)member.getName()));
                }
                comboBoxViewerCellEditor.setInput((Object)functions.toArray());
            } else {
                ArrayList<FunctionCall> functions = new ArrayList<FunctionCall>();
                for (EnumerationMember member : members) {
                    functions.add(ExpressionModelElementFactory.funcCall((String)member.getName()));
                }
                comboBoxViewerCellEditor.setInput((Object)functions.toArray());
            }
            return comboBoxViewerCellEditor;
        }
        if (typedef instanceof BoolTypeDefinition) {
            ComboBoxViewerCellEditor comboBoxViewerCellEditor = new ComboBoxViewerCellEditor((Composite)viewer.getControl(), 8);
            comboBoxViewerCellEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            comboBoxViewerCellEditor.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof BoolConst) {
                        return element.toString();
                    }
                    if (element instanceof Boolean) {
                        return element.toString();
                    }
                    return "";
                }
            });
            if (element.getValue() instanceof BoolConst) {
                comboBoxViewerCellEditor.setInput((Object)new Boolean[]{true, false});
            } else {
                comboBoxViewerCellEditor.setInput((Object)new BoolConst[]{ExpressionModelElementFactory.boolConst((boolean)true), ExpressionModelElementFactory.boolConst((boolean)false)});
            }
            return comboBoxViewerCellEditor;
        }
        TextCellEditor cellEditor = new TextCellEditor((Composite)viewer.getControl());
        this.setupCellEditor((CellEditor)cellEditor);
        return cellEditor;
    }

    protected void setupCellEditor(CellEditor cellEditor) {
        cellEditor.getControl().setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration(cellEditor.getControl(), 16512));
    }

    private Binding[] createBindings(IObservableValue<?> cellObservable, ComboBoxViewerCellEditor cellEditor) {
        Binding[] bindings = new Binding[1];
        IViewerObservableValue viewerSelection = ViewerProperties.singleSelection().observe((Viewer)cellEditor.getViewer());
        bindings[0] = this.dbc.bindValue((IObservableValue)viewerSelection, cellObservable);
        return bindings;
    }

    protected Binding[] createBinding(CellEditor cellEditor, ViewerCell cell, CellEditor editor, DataBindingContext context) {
        final ComplexDataStructure node = (ComplexDataStructure)cell.getElement();
        IExpressionTerm cellValue = node.getValue();
        IObservableValue cellObservable = null;
        if (cellValue instanceof StructureMemberConst) {
            cellObservable = EMFObservables.observeValue((EObject)cellValue, (EStructuralFeature)TermsPackage.Literals.STRUCTURE_MEMBER_CONST__VALUE);
            if (((StructureMemberConst)cellValue).getValue() instanceof FunctionCall) {
                return this.createBindings(cellObservable, (ComboBoxViewerCellEditor)cellEditor);
            }
            if (((StructureMemberConst)cellValue).getValue() instanceof BoolConst) {
                return this.createBindings(cellObservable, (ComboBoxViewerCellEditor)cellEditor);
            }
            return DataBindingUtils.performCellTextBinding((DataBindingContext)this.dbc, (Control)cellEditor.getControl(), (IObservableValue)cellObservable, (IConverter)new ITermToStringConverter(), (IConverter)new StringToIExpressionTermConverter(this.context), (IValidator)new StringToIExpressionTermWithTypeCheckValidatorBase(this.context){

                @Override
                protected String getUnknownTypeMessage() {
                    return "Cannot determine type.";
                }

                @Override
                protected IType getType() {
                    return node.getType();
                }
            });
        }
        if (cellValue instanceof IntConst) {
            return DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)cellEditor.getControl(), (IObservableValue)EMFObservables.observeValue((EObject)cellValue, (EStructuralFeature)TermsPackage.Literals.INT_CONST__VALUE), (IConverter)new GeneralConverter(Integer.TYPE, String.class), (IConverter)new GeneralConverter(String.class, Integer.TYPE), null, null);
        }
        if (cellValue instanceof DoubleConst) {
            return DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)cellEditor.getControl(), (IObservableValue)EMFObservables.observeValue((EObject)cellValue, (EStructuralFeature)TermsPackage.Literals.DOUBLE_CONST__VALUE), (IConverter)new GeneralConverter(Double.TYPE, String.class), (IConverter)new GeneralConverter(String.class, Double.TYPE), null, null);
        }
        if (cellValue instanceof BoolConst) {
            cellObservable = EMFObservables.observeValue((EObject)cellValue, (EStructuralFeature)TermsPackage.Literals.BOOL_CONST__VALUE);
            return this.createBindings(cellObservable, (ComboBoxViewerCellEditor)cellEditor);
        }
        if (cellValue instanceof FunctionCall) {
            cellObservable = EMFObservables.observeValue((EObject)cellValue, (EStructuralFeature)TypesystemPackage.Literals.FUNCTION_CALL_BASE__FUNCTION);
            return this.createBindings(cellObservable, (ComboBoxViewerCellEditor)cellEditor);
        }
        return null;
    }

    protected void saveCellEditorValue(CellEditor cellEditor, ViewerCell cell) {
        super.saveCellEditorValue(cellEditor, cell);
        this.getViewer().refresh();
        ((TreeViewer)this.getViewer()).expandAll();
    }

    private boolean fastCheckComplexDataTypeUnwrap(IExpressionTerm term, IType type, IType parentType, EObject context) {
        ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)parentType, (EObject)context);
        if (typedef instanceof Structure ? !(term instanceof StructureMemberConst) : term instanceof StructureMemberConst) {
            return false;
        }
        IExpressionTerm testValue = term;
        if (testValue instanceof StructureMemberConst) {
            testValue = ((StructureMemberConst)testValue).getValue();
        }
        if (testValue instanceof DefinedConst) {
            return false;
        }
        return ExpressionUtils.fastCheckComplexDataType((IExpressionTerm)testValue, (IType)type, (EObject)context);
    }

    private IExpressionTerm createWithWrap(IType type, String identifier, IType parentType, EObject context) {
        ITypeDefinition typedef = TypeScopeUtils.getTypeDefinition((IType)parentType, (EObject)context);
        IExpressionTerm container = ExpressionUtils.createEmptyConstValue((IType)type, (EObject)context);
        if (typedef instanceof Structure) {
            return ExpressionModelElementFactory.create((String)identifier, (IExpressionTerm)container);
        }
        return container;
    }

    private void removeChild(IExpressionTerm parent, IExpressionTerm child) {
        if (parent instanceof StructureMemberConst) {
            parent = ((StructureMemberConst)parent).getValue();
        }
        if (parent instanceof ArrayConst) {
            ((ArrayConst)parent).getValues().remove((Object)child);
        } else if (parent instanceof StructureConst) {
            ((StructureConst)parent).getMembers().remove((Object)child);
        }
    }

    private void link(IExpressionTerm parent, IExpressionTerm child) {
        if (parent instanceof StructureMemberConst) {
            parent = ((StructureMemberConst)parent).getValue();
        }
        if (parent instanceof ArrayConst) {
            ((ArrayConst)parent).getValues().add((Object)child);
        } else if (parent instanceof StructureConst) {
            ((StructureConst)parent).getMembers().add((Object)((StructureMemberConst)child));
        }
    }

    private void fix(ComplexDataStructure node, ComplexDataStructure parent, EObject context) {
        if (parent == null) {
            return;
        }
        if (!this.fastCheckComplexDataTypeUnwrap(node.getValue(), node.getType(), parent.getType(), context)) {
            if (node.getValue() != null) {
                this.removeChild(parent.getValue(), node.getValue());
            }
            node.setValue(this.createWithWrap(node.getType(), node.getName(), parent.getType(), context));
            this.fix(parent, parent.getParent(), context);
            this.link(parent.getValue(), node.getValue());
        }
    }

    private class GeneralConverter
    extends Converter {
        public GeneralConverter(Object fromType, Object toType) {
            super(fromType, toType);
        }

        public Object convert(Object fromObject) {
            Object toType = this.getToType();
            if (toType == Integer.TYPE) {
                return Integer.parseInt((String)fromObject);
            }
            if (toType == Double.TYPE) {
                return Double.parseDouble((String)fromObject);
            }
            if (toType == Integer.TYPE) {
                return Boolean.parseBoolean((String)fromObject);
            }
            if (toType == String.class) {
                return fromObject.toString();
            }
            return null;
        }
    }
}

