/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.databinding.convert;

import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.behavior.code.CodeSpecification;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionUtils;

public class StatementSequenceToStringConverter
extends Converter {
    private final boolean formatStatements;

    public StatementSequenceToStringConverter(boolean formatStatements) {
        super(StatementSequence.class, String.class);
        this.formatStatements = formatStatements;
    }

    public Object convert(Object fromObject) {
        if (!(fromObject instanceof StatementSequence)) {
            return null;
        }
        StatementSequence statements = (StatementSequence)fromObject;
        if (statements.getStatements().isEmpty()) {
            EObject parent = statements.eContainer();
            return ((CodeSpecification)parent).getStringRepresentation();
        }
        if (this.formatStatements) {
            return ExpressionUtils.formatStatements((String)statements.toString());
        }
        return statements.toString();
    }
}

