/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.databinding.convert;

import java.util.List;
import org.conqat.ide.commons.ui.logging.LoggingUtils;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.ui.AF3ExpressionUIActivator;
import org.fortiss.af3.expression.ui.databinding.CompilerBasedConverterBase;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.ui.utils.ParsingUtils;

public class StringToStructureMemberOrParameterConverter
extends CompilerBasedConverterBase {
    private final boolean structureMode;

    public StringToStructureMemberOrParameterConverter(boolean structureMode, EObject ctx) {
        super(String.class, EList.class, ctx);
        this.structureMode = structureMode;
    }

    public Object convert(Object fromObject) {
        try {
            List pairList = ParsingUtils.splitPairList((String)((String)fromObject), (String)",", (String)":");
            if (this.structureMode) {
                return this.compileStructureMember(pairList);
            }
            return this.compileFunctionParameter(pairList);
        }
        catch (Exception e) {
            LoggingUtils.error((Plugin)AF3ExpressionUIActivator.getDefault(), (String)"Had conversion problems not caught by the validator", (Throwable)e);
            return null;
        }
    }

    private Object compileStructureMember(List<Pair<String, String>> pairList) {
        BasicEList members = new BasicEList();
        for (Pair<String, String> pair : pairList) {
            IType type = this.compiler.compileType((String)pair.getSecond(), this.context);
            StructureMember str = ExpressionModelElementFactory.createStructureMember((String)((String)pair.getFirst()).trim(), (IType)type);
            members.add((Object)str);
        }
        return members;
    }

    private Object compileFunctionParameter(List<Pair<String, String>> pairList) {
        BasicEList parameters = new BasicEList();
        for (Pair<String, String> pair : pairList) {
            IType type = this.compiler.compileType((String)pair.getSecond(), this.context);
            FunctionParameter param = ExpressionModelElementFactory.createFunctionParameter((String)((String)pair.getFirst()).trim(), (IType)type);
            parameters.add((Object)param);
        }
        return parameters;
    }
}

