/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.databinding.convert;

import java.util.List;
import org.conqat.ide.commons.ui.logging.LoggingUtils;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.types.TInt;
import org.fortiss.af3.expression.ui.AF3ExpressionUIActivator;
import org.fortiss.af3.project.model.typesystem.IType;

public class StructureMemberOrParameterToStringConverter
extends Converter {
    public StructureMemberOrParameterToStringConverter() {
        super(EList.class, String.class);
    }

    public Object convert(Object fromObject) {
        StringBuffer sb = new StringBuffer();
        for (Object obj : (List)fromObject) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (obj instanceof StructureMember) {
                StructureMember sm = (StructureMember)obj;
                sb.append(sm.getName()).append(":").append(sm.getType().toString());
                continue;
            }
            if (obj instanceof FunctionParameter) {
                FunctionParameter fp = (FunctionParameter)obj;
                IType type = fp.getType();
                String typeString = type instanceof TInt ? "int" : type.toString();
                sb.append(fp.getVariable().getIdentifier()).append(":").append(typeString);
                continue;
            }
            LoggingUtils.error((Plugin)AF3ExpressionUIActivator.getDefault(), (String)("Had conversion problems: object in list is not StructureMember / FunctionParameter: was " + String.valueOf(obj.getClass())), null);
        }
        return sb.toString();
    }
}

