/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.databinding.validate;

import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.evaluation.NoVal;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.expression.ui.databinding.validate.StringToIExpressionTermValidator;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.typesystem.ITypeChecker;
import org.fortiss.af3.project.utils.TypeScopeUtils;

public abstract class StringToIExpressionTermWithTypeCheckValidatorBase
extends StringToIExpressionTermValidator {
    public StringToIExpressionTermWithTypeCheckValidatorBase(EObject context) {
        super(context);
    }

    @Override
    public IStatus validate(Object value) {
        IStatus stat = super.validate(value);
        if (stat.isOK()) {
            if (NoVal.isNoValConst((ITerm)this.expression)) {
                if (this.isNoValAllowed()) {
                    return Status.OK_STATUS;
                }
                return ValidationStatus.cancel((String)"NoVal keyword not allowed!");
            }
            IType type = this.getType();
            if (type == null || type instanceof TDefinedType && TypeScopeUtils.getTypeDefinition((IType)type, (EObject)this.context) == null) {
                return ValidationStatus.cancel((String)this.getUnknownTypeMessage());
            }
            ITypeChecker tc = this.handler.getTypeChecker();
            return tc.typecheck((ITerm)this.expression, type, this.context);
        }
        return stat;
    }

    protected abstract String getUnknownTypeMessage();

    protected abstract IType getType();

    protected boolean isNoValAllowed() {
        return true;
    }
}

