/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.databinding.validate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.language.ParseException;
import org.fortiss.af3.expression.model.terms.Var;
import org.fortiss.af3.expression.ui.databinding.CompilerBasedValidatorBase;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.ui.utils.ParsingUtils;

public class StringToStructureMemberOrParameterValidator
extends CompilerBasedValidatorBase {
    private static final Pattern PATTERN = Pattern.compile("[^a-zA-Z0-9_,:\\s]+");
    private final boolean structureMode;

    public StringToStructureMemberOrParameterValidator(boolean structureMode, EObject model) {
        super(model);
        this.structureMode = structureMode;
    }

    public IStatus validate(Object value) {
        String v = (String)value;
        Matcher m = PATTERN.matcher(v);
        if (m.find()) {
            return ValidationStatus.cancel((String)"Illegal character used!");
        }
        try {
            for (Pair pair : ParsingUtils.splitPairList((String)v, (String)",", (String)":")) {
                if (this.structureMode && ((String)pair.getFirst()).trim().startsWith("_")) {
                    return ValidationStatus.cancel((String)"Structure member must start with character.");
                }
                if (!this.structureMode) {
                    try {
                        ITerm t = this.compiler.compileTerm((String)pair.getFirst(), this.context);
                        if (!(t instanceof Var)) {
                            return ValidationStatus.cancel((String)"Parameter identifier must be a variable.");
                        }
                    }
                    catch (ParseException e) {
                        return ValidationStatus.cancel((String)e.getMessage());
                    }
                }
                if (((String)pair.getSecond()).trim().length() == 0) {
                    return ValidationStatus.cancel((String)"Missing type after :");
                }
                try {
                    this.compiler.compileType((String)pair.getSecond(), this.context);
                }
                catch (ParseException e) {
                    return ValidationStatus.cancel((String)e.getMessage());
                }
            }
        }
        catch (java.text.ParseException e) {
            if (this.structureMode) {
                return ValidationStatus.cancel((String)"Format should be: <structure member name>:<type>");
            }
            return ValidationStatus.cancel((String)"Format should be: <parameter name>:<type>");
        }
        return ValidationStatus.ok();
    }
}

