/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.editor;

import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.ui.editor.DataDictionaryEditorContentProvider;
import org.fortiss.af3.expression.ui.editor.DataDictionaryEditorUIProvider;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableViewer;
import org.fortiss.tooling.kernel.ui.extension.base.FXEditorBase;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;
import org.fortiss.tooling.kernel.utils.KernelServiceBasedModelListenerBase;

public class DataDictionaryEditor
extends FXEditorBase<DataDictionary>
implements ISelectionProvider {
    private DynamicTreeTableViewer<EObject> treeTableViewer;
    private TextField filterWidget;
    private KernelServiceBasedModelListenerBase<DataDictionary> modelListener;

    protected Parent createSceneRoot() {
        DataDictionary dd = (DataDictionary)this.getEditedObject();
        this.modelListener = new KernelServiceBasedModelListenerBase<DataDictionary>(dd){

            public void updateComplete(List<Notification> notifications) {
                DataDictionaryEditor.this.treeTableViewer.update();
            }
        };
        this.modelListener.register();
        DataDictionaryEditorContentProvider contentProvider = new DataDictionaryEditorContentProvider();
        DataDictionaryEditorUIProvider uiProvider = new DataDictionaryEditorUIProvider(this);
        BorderPane pane = new BorderPane();
        this.filterWidget = new TextField();
        this.filterWidget.textProperty().addListener((obs, oVal, nVal) -> {
            contentProvider.setFilterExpression((String)nVal);
            this.treeTableViewer.update();
        });
        this.treeTableViewer = new DynamicTreeTableViewer((Object)dd, true, 2, (DynamicTreeContentProviderBase)contentProvider, (DynamicTreeTableUIProviderBase)uiProvider);
        this.treeTableViewer.addColumn("Name", 300);
        this.treeTableViewer.addColumn("Type", 160);
        this.treeTableViewer.addColumn("Comment", 500);
        TreeTableView view = this.treeTableViewer.getControl();
        view.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            TreeItem selected = (TreeItem)view.getSelectionModel().getSelectedItem();
            INavigatorService.getInstance().setCurrentSelection((ISelection)new StructuredSelection(selected.getValue()));
        });
        pane.setTop((Node)this.filterWidget);
        pane.setCenter((Node)view);
        return pane;
    }

    public Class<? extends EObject>[] getVisibleEObjectTypes() {
        return new Class[]{((DataDictionary)this.editedObject).getClass(), Structure.class, Enumeration.class};
    }

    public void dispose() {
        this.modelListener.unregister();
        super.dispose();
    }

    public void navigateToFX(EObject element) {
        this.treeTableViewer.navigateTo((Object)element);
        INavigatorService.getInstance().setCurrentSelection((ISelection)new StructuredSelection((Object)element));
    }
}

