/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionDeployedParameter;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeContentProviderBase;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;

final class DataDictionaryEditorContentProvider
extends DynamicTreeContentProviderBase<EObject> {
    DataDictionaryEditorContentProvider() {
    }

    protected Comparator<EObject> getSortingComparator() {
        return (e1, e2) -> {
            if (e1 instanceof TypeDefinition) {
                if (e2 instanceof TypeDefinition) {
                    String e1Name = ((TypeDefinition)e1).getName();
                    return e1Name.compareToIgnoreCase(((TypeDefinition)e2).getName());
                }
                return -1;
            }
            if (e1 instanceof FunctionDefinition) {
                if (e2 instanceof FunctionDefinition) {
                    String e1FuncName = ((FunctionDefinition)e1).getFunction().getName();
                    String e2FuncName = ((FunctionDefinition)e2).getFunction().getName();
                    return e1FuncName.compareToIgnoreCase(e2FuncName);
                }
                return 1;
            }
            if (e1 instanceof INamedElement && e2 instanceof INamedElement) {
                String e1Name = ((INamedElement)e1).getName();
                return e1Name.compareToIgnoreCase(((INamedElement)e2).getName());
            }
            return 0;
        };
    }

    protected boolean filter(EObject eo, String filterValue) {
        if (filterValue == null || "".equals(filterValue.trim())) {
            return true;
        }
        String effectiveFilter = filterValue.toLowerCase();
        return this.filteredResult(eo, effectiveFilter);
    }

    protected Collection<? extends EObject> getChildren(EObject parent) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (parent instanceof DataDictionary) {
            DataDictionary dic = (DataDictionary)parent;
            result.addAll((Collection<Object>)dic.getFunctions());
            result.addAll((Collection<Object>)dic.getTypeDefinitions());
        }
        if (parent instanceof Enumeration) {
            for (EnumerationMember dc : ((Enumeration)parent).getMembers()) {
                result.add(dc);
            }
        }
        if (parent instanceof Structure) {
            for (StructureMember mem : ((Structure)parent).getMembers()) {
                result.add(mem);
            }
        }
        return result;
    }

    private boolean filteredResult(EObject eo, String effectiveFilter) {
        if (eo instanceof Array) {
            INamedCommentedElement nceArr = (INamedCommentedElement)eo;
            return this.getFilteredNameMatch(nceArr.getName(), effectiveFilter);
        }
        if (eo instanceof FunctionDeployedParameter) {
            FunctionDeployedParameter nceFuncDepParam = (FunctionDeployedParameter)eo;
            return this.getFilteredNameMatch(nceFuncDepParam.getFunction().getName(), effectiveFilter);
        }
        if (eo instanceof Structure) {
            Structure nceStruct = (Structure)eo;
            return this.getFilteredNameMatch(nceStruct.getName(), effectiveFilter);
        }
        if (eo instanceof StructureMember) {
            StructureMember nceStructMem = (StructureMember)eo;
            return this.getFilteredNameMatch(nceStructMem.getName(), effectiveFilter);
        }
        if (eo instanceof Enumeration) {
            Enumeration nceEnum = (Enumeration)eo;
            return this.getFilteredNameMatch(nceEnum.getName(), effectiveFilter);
        }
        if (eo instanceof EnumerationMember) {
            EnumerationMember nceEnumMem = (EnumerationMember)eo;
            return this.getFilteredNameMatch(nceEnumMem.getName(), effectiveFilter);
        }
        if (eo instanceof FunctionDefinition) {
            FunctionDefinition nceFuncDef = (FunctionDefinition)eo;
            return this.getFilteredNameMatch(nceFuncDef.getFunction().getName(), effectiveFilter);
        }
        return false;
    }

    private boolean getFilteredNameMatch(String name, String effectiveFilter) {
        return name.toLowerCase().contains(effectiveFilter);
    }
}

