/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.editor;

import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.Dragboard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.ui.editor.DataDictionaryEditor;
import org.fortiss.tooling.base.ui.utils.ContextMenuUtils;
import org.fortiss.tooling.base.ui.utils.FXDNDUtils;
import org.fortiss.tooling.common.ui.javafx.control.treetableview.DynamicTreeTableUIProviderBase;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;

final class DataDictionaryEditorUIProvider
extends DynamicTreeTableUIProviderBase<EObject> {
    private final DataDictionaryEditor editor;

    public DataDictionaryEditorUIProvider(DataDictionaryEditor editor) {
        this.editor = editor;
    }

    public String getLabel(EObject element, int column) {
        if (column == 0) {
            return this.getModelElementHandlerName(element);
        }
        if (column == 1) {
            if (element instanceof StructureMember) {
                return ((StructureMember)element).getType().toString();
            }
            if (element instanceof FunctionDefinition) {
                FunctionDefinition fun = (FunctionDefinition)element;
                return fun.getReturnType().toString();
            }
            if (element instanceof Array) {
                Array array = (Array)element;
                return array.getType().toString() + "[" + array.getLength() + "]";
            }
            return "";
        }
        if (column == 2) {
            if (element instanceof FunctionDefinition) {
                FunctionDefinition fdef = (FunctionDefinition)element;
                return fdef.getFunction().getComment();
            }
            if (element instanceof INamedCommentedElement) {
                return ((INamedCommentedElement)element).getComment();
            }
            return "";
        }
        return "";
    }

    public Node getIconNode(EObject element, int column) {
        if (column != 0) {
            return null;
        }
        return this.getModelElementHandlerIcon(element);
    }

    public boolean dragOver(EObject element, Dragboard dragboard) {
        return FXDNDUtils.canCompose((Dragboard)dragboard, (EObject)element);
    }

    public boolean dropClipboardContent(EObject element, Dragboard dragboard) {
        return FXDNDUtils.compose((Dragboard)dragboard, (EObject)element);
    }

    public boolean isEditable(int column) {
        return column == 2;
    }

    public void updateValue(EObject element, int column, Object value) {
        if (column == 2 && element instanceof INamedCommentedElement) {
            INamedCommentedElement elem = (INamedCommentedElement)element;
            ICommandStackService.getInstance().runAsCommand((EObject)elem, () -> elem.setComment((String)value));
        }
    }

    public void select(EObject oldValue, EObject newValue) {
        StructuredSelection selection = newValue == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)newValue);
        this.editor.getSite().getSelectionProvider().setSelection((ISelection)selection);
    }

    private String getModelElementHandlerName(EObject eo) {
        return IModelElementHandlerService.getInstance().getName(eo);
    }

    private Node getModelElementHandlerIcon(EObject eo) {
        if (eo == null) {
            return null;
        }
        return IModelElementHandlerService.getInstance().getFXIcon(eo);
    }

    public ContextMenu createContextMenu(EObject element, int column) {
        if (element == null || column != 0) {
            return null;
        }
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Collection)ContextMenuUtils.createPrototypeMenu((EObject)element, null, (boolean)false));
        contextMenu.getItems().add((Object)ContextMenuUtils.createDeleteMenu((EObject)element));
        contextMenu.getItems().addAll((Collection)IContextMenuService.getInstance().getFXMenuItemsForElement(element, null));
        return contextMenu;
    }
}

