/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.editor;

import java.util.LinkedList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import org.fortiss.af3.expression.language.ParseException;
import org.fortiss.af3.expression.language.TypeChecker;
import org.fortiss.af3.expression.language.TypeSystemHandler;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.types.impl.TBoolStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TDoubleStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TIntStaticImpl;
import org.fortiss.af3.expression.ui.AF3ExpressionUIActivator;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.ITermEvaluator;
import org.fortiss.af3.project.typesystem.ITypeSystemCompiler;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;
import org.fortiss.tooling.kernel.ui.extension.base.FXEditorBase;

public final class DataDictionaryEvaluator
extends FXEditorBase<DataDictionary> {
    private static final String WELCOME = "Enter expression below and hit return.\nUse up and down arrow keys to cycle through previous inputs.";
    private TextArea evaluatorOutput = new TextArea();
    private Label evaluatorHelp = new Label("Enter expression below and hit return.\nUse up and down arrow keys to cycle through previous inputs.", (Node)INFO);
    private TextField evaluatorInput = new TextField();
    private final LinkedList<String> evaluatorStack = new LinkedList();
    private int stackPointer = 0;
    private static ImageView ERROR = new ImageView(GraphicUtils.getFXImage((String)AF3ExpressionUIActivator.PLUGIN_ID, (String)"icons/error.gif"));
    private static ImageView INFO = new ImageView(GraphicUtils.getFXImage((String)AF3ExpressionUIActivator.PLUGIN_ID, (String)"icons/info.gif"));
    private boolean canExecute = false;
    private static final IType[] DEFAULT_TYPES = new IType[]{TBoolStaticImpl.INSTANCE, TIntStaticImpl.INSTANCE, TDoubleStaticImpl.INSTANCE};

    protected Parent createSceneRoot() {
        BorderPane bpane = new BorderPane();
        bpane.setCenter((Node)this.evaluatorOutput);
        VBox vbox = new VBox(new Node[]{this.evaluatorHelp, this.evaluatorInput});
        bpane.setBottom((Node)vbox);
        this.registerListeners();
        return bpane;
    }

    private void registerListeners() {
        this.evaluatorInput.setOnKeyReleased(evt -> {
            KeyCode kc = evt.getCode();
            if (kc == KeyCode.ENTER && this.canExecute) {
                this.setHelpAndCanExecuteFlag("", null);
                this.evaluate();
                return;
            }
            if (kc == KeyCode.DOWN) {
                if (this.stackPointer < this.evaluatorStack.size() - 1) {
                    ++this.stackPointer;
                    this.evaluatorInput.setText(this.evaluatorStack.get(this.stackPointer));
                } else if (this.stackPointer == this.evaluatorStack.size() - 1) {
                    ++this.stackPointer;
                    this.evaluatorInput.setText("");
                }
            } else if (kc == KeyCode.UP && this.stackPointer > 0) {
                --this.stackPointer;
                this.evaluatorInput.setText(this.evaluatorStack.get(this.stackPointer));
            }
            this.setHelpAndCanExecuteFlag("", null);
            String input = this.evaluatorInput.getText().trim();
            ITypeSystemCompiler compiler = TypeSystemHandler.INSTANCE.getTypeSystemCompiler();
            ITerm term = null;
            try {
                term = compiler.compileTerm(input, this.editedObject);
            }
            catch (ParseException pe) {
                this.setHelpAndCanExecuteFlag(pe.getMessage(), ERROR);
            }
            if (term instanceof IExpressionTerm) {
                this.typecheckTerm((IExpressionTerm)term);
            } else {
                this.setHelpAndCanExecuteFlag("Input is not an expression.", ERROR);
            }
        });
    }

    private void setHelpAndCanExecuteFlag(String text, ImageView image) {
        this.evaluatorHelp.setText(text);
        this.evaluatorHelp.setGraphic((Node)image);
        this.canExecute = image != ERROR;
    }

    private void evaluate() {
        ITerm inputTerm = this.compileInput(this.evaluatorInput.getText());
        Term<? extends ITerm> resultTerm = this.evaluateTerm(inputTerm);
        this.evaluatorOutput.appendText(" > " + inputTerm.toString() + "\n");
        this.evaluatorOutput.appendText(" =   " + resultTerm.toString() + "\n\n");
        this.evaluatorStack.add(inputTerm.toString());
        this.stackPointer = this.evaluatorStack.size();
        this.evaluatorInput.setText("");
        this.setHelpAndCanExecuteFlag("", null);
    }

    private Term<? extends ITerm> evaluateTerm(ITerm term) {
        ITermEvaluator evaluator = ITypeSystemService.INSTANCE.getHandler(this.editedObject).getTermEvaluator();
        IEvaluationContext context = ITypeSystemService.INSTANCE.createEvaluationContext(this.editedObject);
        return evaluator.evaluate(term, context);
    }

    private void typecheckTerm(IExpressionTerm term) {
        TypeChecker tc = new TypeChecker();
        IType[] iTypeArray = DEFAULT_TYPES;
        int n = DEFAULT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (tc.typecheck((ITerm)term, t, this.editedObject).isOK()) {
                this.setDerivedTypeHelp(t);
                return;
            }
            ++n2;
        }
        for (TypeDefinition td : ((DataDictionary)this.editedObject).getTypeDefinitions()) {
            IType t = td.createIType();
            if (!tc.typecheck((ITerm)term, t, this.editedObject).isOK()) continue;
            this.setDerivedTypeHelp(t);
            return;
        }
        this.setHelpAndCanExecuteFlag("No type could be derived for entered expression", ERROR);
    }

    private void setDerivedTypeHelp(IType t) {
        this.setHelpAndCanExecuteFlag("Derived type is: '" + t.toString() + "'", INFO);
    }

    private ITerm compileInput(String input) {
        input = input.trim();
        return TypeSystemHandler.INSTANCE.getTypeSystemCompiler().compileTerm(input, this.editedObject);
    }

    public void setFocus() {
        this.evaluatorInput.requestFocus();
    }
}

