/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.prototypes;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.DefinitionsFactory;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.FunctionDeployedParameter;
import org.fortiss.af3.expression.model.definitions.FunctionParameter;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.impl.ReturnStaticImpl;
import org.fortiss.af3.expression.model.terms.imperative.impl.StatementSequenceStaticImpl;
import org.fortiss.af3.expression.model.terms.impl.IntConstStaticImpl;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.kernel.extension.base.PrototypeProviderBase;

public final class PrototypeProvider
extends PrototypeProviderBase {
    protected static final String CATEGORY_NAME = "Expressions";

    protected void registerPrototypes() {
        this.setupDataDictionaryPrototypes();
    }

    private void setupDataDictionaryPrototypes() {
        boolean expandByDefault = true;
        this.registerPrototypeCategory(CATEGORY_NAME, expandByDefault);
        this.registerPrimaryPrototype("Data Dictionary", (EObject)ExpressionModelElementFactory.createDataDictionary(), CATEGORY_NAME);
        this.setupEnumerationPrototype();
        this.setEnumerationMemberPrototype();
        this.setupStructurePrototype();
        this.setupStructureMemberPrototype();
        this.setupUserDefinedFunctionPrototype();
        this.setupDeployedParameterPrototype();
        this.setupArrayPrototypes();
    }

    private void setupArrayPrototypes() {
        Array array = DefinitionsFactory.eINSTANCE.createArray();
        array.setName("MyArray");
        array.setType((IType)ExpressionModelElementFactory.intType());
        array.setLength(4);
        this.registerPrototype("Array", (EObject)array, CATEGORY_NAME);
    }

    private void setupUserDefinedFunctionPrototype() {
        FunctionDefinition fun = ExpressionModelElementFactory.createUserDefinedFunctionDefinition((String)"myFun", (IType)ExpressionModelElementFactory.intType());
        FunctionParameter param = ExpressionModelElementFactory.createFunctionParameter((String)"_V", (IType)ExpressionModelElementFactory.boolType());
        fun.getParameters().add((Object)param);
        Return ret = ReturnStaticImpl.create((IExpressionTerm)IntConstStaticImpl.create((int)0));
        fun.setDefinition(StatementSequenceStaticImpl.create((IStatementTerm)ret));
        this.registerPrototype("Function", (EObject)fun, CATEGORY_NAME);
    }

    private void setupDeployedParameterPrototype() {
        FunctionDeployedParameter dplPrm = ExpressionModelElementFactory.createDeployedParameter((String)"myParam", (IType)ExpressionModelElementFactory.intType());
        Return ret = ReturnStaticImpl.create((IExpressionTerm)IntConstStaticImpl.create((int)0));
        dplPrm.setDefinition(StatementSequenceStaticImpl.create((IStatementTerm)ret));
        dplPrm.getFunction().setComment("Deployed parameters are used to return values read from a configuration file during runtime. The entered definition is only used for simulation.");
        dplPrm.setLookupUrl("url/myParam");
        this.registerPrototype("Deployed Parameter", (EObject)dplPrm, CATEGORY_NAME);
    }

    private void setupStructureMemberPrototype() {
        this.registerPrototype("Structure Member", (EObject)ExpressionModelElementFactory.createStructureMember((String)"member", (IType)ExpressionModelElementFactory.intType()), CATEGORY_NAME);
    }

    private void setupStructurePrototype() {
        Structure struct = ExpressionModelElementFactory.createStructure((String)"MyStruct");
        struct.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember((String)"x", (IType)ExpressionModelElementFactory.intType()));
        struct.getMembers().add((Object)ExpressionModelElementFactory.createStructureMember((String)"y", (IType)ExpressionModelElementFactory.intType()));
        this.registerPrototype("Structure", (EObject)struct, CATEGORY_NAME);
    }

    private void setEnumerationMemberPrototype() {
        this.registerPrototype("Enumeration Member", (EObject)ExpressionModelElementFactory.createEnumerationMember((String)"Member"), CATEGORY_NAME);
    }

    private void setupEnumerationPrototype() {
        Enumeration en = ExpressionModelElementFactory.createEnumeration((String)"MyEnum");
        en.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember((String)"First"));
        en.getMembers().add((Object)ExpressionModelElementFactory.createEnumerationMember((String)"Second"));
        this.registerPrototype("Enumeration", (EObject)en, CATEGORY_NAME);
    }
}

