/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.IContextMenuContributor;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;

public abstract class RenameContextMenu
implements IContextMenuContributor {
    public List<IContributionItem> getContributedItems(EObject selection, ContextMenuContextProvider contextProvider) {
        if (selection != null && this.canBeRenamed(selection)) {
            RenameAction action = new RenameAction(selection);
            ArrayList<IContributionItem> contributionItems = new ArrayList<IContributionItem>();
            contributionItems.add((IContributionItem)new ActionContributionItem((IAction)action));
            return contributionItems;
        }
        return Collections.emptyList();
    }

    protected abstract String getName(EObject var1);

    protected abstract void setName(EObject var1, String var2);

    protected abstract boolean canBeRenamed(EObject var1);

    public String getMenuSectionID() {
        return "afterglobal";
    }

    protected void renameAll(EObject renamedElt, String newName) {
        String oldName = this.getName(renamedElt);
        ITopLevelElement root = IPersistencyService.getInstance().getTopLevelElementFor(renamedElt);
        EObject rootElt = root.getRootModelElement();
        this.setName(renamedElt, newName);
        this.renameElement(rootElt, oldName, newName);
        TreeIterator iter = rootElt.eAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            this.renameElement(eo, oldName, newName);
        }
    }

    protected abstract void renameElement(EObject var1, String var2, String var3);

    private class RenameAction
    extends Action {
        private EObject selectedElt;

        RenameAction(EObject elt) {
            super("Rename refactoring...");
            this.selectedElt = elt;
        }

        public void run() {
            final InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Rename refactoring", "New name:", RenameContextMenu.this.getName(this.selectedElt), (IInputValidator)new RenameValidator());
            if (dlg.open() != 0 || dlg.getValue().equals(RenameContextMenu.this.getName(this.selectedElt))) {
                return;
            }
            ICommandStackService.getInstance().runAsCommand(this.selectedElt, new Runnable(){

                @Override
                public void run() {
                    RenameContextMenu.this.renameAll(RenameAction.this.selectedElt, dlg.getValue());
                }
            });
        }

        private class RenameValidator
        implements IInputValidator {
            private RenameValidator() {
            }

            public String isValid(String newText) {
                if (newText.equals(RenameContextMenu.this.getName(RenameAction.this.selectedElt))) {
                    return "Warning: this feature is experimental, all the elements that will be\n renamed should be properly renamed, but it is not guaranteed that\n all eligible elements are indeed renamed.";
                }
                return null;
            }
        }
    }
}

