/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.tutorial;

import java.util.function.Predicate;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.ui.AF3ExpressionUIActivator;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.extension.ITutorialWhitelistProvider;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.ui.extension.base.TutorialStepUIAtomicBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public final class CreateEnumerationStep
extends TutorialStepUIAtomicBase
implements Predicate<EObject>,
ITutorialWhitelistProvider {
    private static final String BUNDLE_LOCATION = Platform.getBundle((String)AF3ExpressionUIActivator.PLUGIN_ID).getLocation();
    private static final String URL = BUNDLE_LOCATION.replace("reference:file:", "") + "html/2_1CreateEnumeration.html";

    public CreateEnumerationStep() {
        super("2.1. Create Enumeration ABC with Members Alpha, Beta, and Gamma", URL);
    }

    public String getShortTitle() {
        return "2.1. Create Enumeration ABC";
    }

    public boolean prototypeActive(Prototype prototype) {
        EObject proto = prototype.getPrototype();
        return ReflectionUtils.isInstanceOfAny((Object)proto, (Class[])new Class[]{Enumeration.class, EnumerationMember.class});
    }

    @Override
    public boolean test(EObject model) {
        DataDictionary dd;
        if (model instanceof FileProject && (dd = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)model, DataDictionary.class)) != null) {
            return this.checkDataDictionaryForCompletion(dd);
        }
        return false;
    }

    private boolean checkDataDictionaryForCompletion(DataDictionary dd) {
        return dd.getEnumerations().stream().anyMatch(e -> this.checkEnumerationForCompletion((Enumeration)e));
    }

    private boolean checkEnumerationForCompletion(Enumeration e) {
        boolean nameSize = e.getName().equals("ABC") && e.getMembers().size() == 3;
        boolean alpha = false;
        boolean beta = false;
        boolean gamma = false;
        for (EnumerationMember mem : e.getMembers()) {
            if ("Alpha".equals(mem.getName())) {
                alpha = true;
                continue;
            }
            if ("Beta".equals(mem.getName())) {
                beta = true;
                continue;
            }
            if (!"Gamma".equals(mem.getName())) continue;
            gamma = true;
        }
        return nameSize && alpha && beta && gamma;
    }

    public Predicate<EObject> getCompletionChecker() {
        return this;
    }
}

