/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.tutorial;

import java.util.function.Predicate;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.types.TDouble;
import org.fortiss.af3.expression.ui.AF3ExpressionUIActivator;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.tooling.kernel.extension.ITutorialWhitelistProvider;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.ui.extension.base.TutorialStepUIAtomicBase;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public final class CreateStructureStep
extends TutorialStepUIAtomicBase
implements Predicate<EObject>,
ITutorialWhitelistProvider {
    private static final String BUNDLE_LOCATION = Platform.getBundle((String)AF3ExpressionUIActivator.PLUGIN_ID).getLocation();
    private static final String URL = BUNDLE_LOCATION.replace("reference:file:", "") + "html/2_2CreateStructureStep.html";

    public CreateStructureStep() {
        super("2.2. Create Structure Point with Members x and y of type double.", URL);
    }

    public String getShortTitle() {
        return "2.2. Create Structure Point";
    }

    public boolean prototypeActive(Prototype prototype) {
        EObject proto = prototype.getPrototype();
        return ReflectionUtils.isInstanceOfAny((Object)proto, (Class[])new Class[]{Structure.class, StructureMember.class});
    }

    @Override
    public boolean test(EObject model) {
        DataDictionary dd;
        if (model instanceof FileProject && (dd = (DataDictionary)KernelModelElementUtils.getRootElement((EObject)model, DataDictionary.class)) != null) {
            return this.checkDataDictionaryForCompletion(dd);
        }
        return false;
    }

    private boolean checkDataDictionaryForCompletion(DataDictionary dd) {
        return dd.getStructures().stream().anyMatch(s -> this.checkStructureForCompletion((Structure)s));
    }

    private boolean checkStructureForCompletion(Structure s) {
        boolean nameSize = s.getName().equals("Point") && s.getMembers().size() == 2;
        boolean x = false;
        boolean y = false;
        for (StructureMember mem : s.getMembers()) {
            if (!(mem.getType() instanceof TDouble)) continue;
            if ("x".equals(mem.getName())) {
                x = true;
                continue;
            }
            if (!"y".equals(mem.getName())) continue;
            y = true;
        }
        return nameSize && x && y;
    }

    public Predicate<EObject> getCompletionChecker() {
        return this;
    }
}

