/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.expression.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.fortiss.af3.expression.model.DataDictionary;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.EnumerationMember;
import org.fortiss.af3.expression.model.definitions.FunctionDefinition;
import org.fortiss.af3.expression.model.definitions.TypeDefinition;
import org.fortiss.af3.expression.model.terms.impl.BoolConstStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TBoolStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TDoubleStaticImpl;
import org.fortiss.af3.expression.model.types.impl.TIntStaticImpl;
import org.fortiss.af3.expression.ui.AF3ExpressionUIActivator;
import org.fortiss.tooling.base.ui.fieldassist.FieldAssistImageRegistry;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ExpressionFieldAssistUtils {
    public static String[] PRIMITIVE_TYPES = new String[]{TBoolStaticImpl.INSTANCE.toString(), TIntStaticImpl.INSTANCE.toString(), TDoubleStaticImpl.INSTANCE.toString()};
    public static String[] PRIMITIVE_VALUES = new String[]{BoolConstStaticImpl.TRUE.toString(), BoolConstStaticImpl.FALSE.toString()};
    public static String[] USEFUL_EXPRESSIONS = new String[]{"return", "if (  ){\n\n}", "else {\n\n}"};
    static Image PRIMITIVE_TYPE_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/primitivetype.gif").createImage();
    static Image PRIMITIVE_VALUE_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/primitivevalue.gif").createImage();
    static Image USEFUL_EXPRESSION_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/usefulexpression.gif").createImage();
    static Image NOVAL_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/noval.gif").createImage();
    static Image FUNCTION_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/function.png").createImage();
    static Image ENUMERATION_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/enumeration.gif").createImage();
    static Image MEMBER_ICON = AF3ExpressionUIActivator.getImageDescriptor("/icons/member.png").createImage();

    static {
        FieldAssistImageRegistry.put((String)"NoVal", (Image)NOVAL_ICON);
        for (String type : ExpressionFieldAssistUtils.getPrimitiveTypes()) {
            FieldAssistImageRegistry.put((String)type, (Image)PRIMITIVE_TYPE_ICON);
        }
        for (String value : ExpressionFieldAssistUtils.getPrimitiveValues()) {
            FieldAssistImageRegistry.put((String)value, (Image)PRIMITIVE_VALUE_ICON);
        }
        for (String exp : ExpressionFieldAssistUtils.getUsefulExpressions()) {
            FieldAssistImageRegistry.put((String)exp, (Image)USEFUL_EXPRESSION_ICON);
        }
    }

    public static DataDictionary getDataDictionary(EObject element) {
        return (DataDictionary)KernelModelElementUtils.getRootElement((EObject)element, DataDictionary.class);
    }

    public static List<String> getPrimitiveTypes() {
        return Arrays.asList(PRIMITIVE_TYPES);
    }

    public static List<String> getPrimitiveValues() {
        return Arrays.asList(PRIMITIVE_VALUES);
    }

    public static List<String> getUsefulExpressions() {
        return Arrays.asList(USEFUL_EXPRESSIONS);
    }

    public static ArrayList<String> getTypeDefinitions(EObject element) {
        ArrayList<String> result = new ArrayList<String>();
        DataDictionary dd = ExpressionFieldAssistUtils.getDataDictionary(element);
        if (dd == null) {
            return result;
        }
        for (TypeDefinition def : dd.getTypeDefinitions()) {
            result.add(def.getName());
            FieldAssistImageRegistry.put((String)def.getName(), (Image)ENUMERATION_ICON);
        }
        return result;
    }

    public static ArrayList<String> getFunctions(EObject element) {
        ArrayList<String> result = new ArrayList<String>();
        DataDictionary dd = ExpressionFieldAssistUtils.getDataDictionary(element);
        if (dd == null) {
            return result;
        }
        for (FunctionDefinition def : dd.getFunctions()) {
            result.add(def.getFunction().getName());
            FieldAssistImageRegistry.put((String)def.getFunction().getName(), (Image)FUNCTION_ICON);
        }
        return result;
    }

    public static ArrayList<String> getAllConstructors(EObject element, boolean includeNoVal) {
        ArrayList<String> result = new ArrayList<String>();
        DataDictionary dd = ExpressionFieldAssistUtils.getDataDictionary(element);
        if (dd == null) {
            return result;
        }
        for (Enumeration def : dd.getEnumerations()) {
            for (EnumerationMember mem : def.getMembers()) {
                result.add(mem.getName() + "()");
                FieldAssistImageRegistry.put((String)(mem.getName() + "()"), (Image)MEMBER_ICON);
            }
        }
        if (includeNoVal) {
            result.add("NoVal");
        }
        return result;
    }

    public static ArrayList<String> getAllConstructorsWithoutBrackets(EObject element, boolean includeNoVal) {
        ArrayList<String> result = new ArrayList<String>();
        DataDictionary dd = ExpressionFieldAssistUtils.getDataDictionary(element);
        if (dd == null) {
            return result;
        }
        for (Enumeration def : dd.getEnumerations()) {
            for (EnumerationMember mem : def.getMembers()) {
                result.add(mem.getName());
                FieldAssistImageRegistry.put((String)(mem.getName() + "()"), (Image)MEMBER_ICON);
            }
        }
        if (includeNoVal) {
            result.add("NoVal");
        }
        return result;
    }

    public static ArrayList<String> getConstructorsForType(String type, boolean includeNoVal, EObject element) {
        ArrayList<String> result = new ArrayList<String>();
        if (type.equals(TBoolStaticImpl.INSTANCE.toString())) {
            result.addAll(ExpressionFieldAssistUtils.getPrimitiveValues());
        } else {
            DataDictionary dd = ExpressionFieldAssistUtils.getDataDictionary(element);
            if (dd == null) {
                return result;
            }
            for (Enumeration def : dd.getEnumerations()) {
                if (!def.getName().equals(type)) continue;
                for (EnumerationMember mem : def.getMembers()) {
                    result.add(mem.getName() + "()");
                    FieldAssistImageRegistry.put((String)(mem.getName() + "()"), (Image)MEMBER_ICON);
                }
            }
        }
        if (includeNoVal) {
            result.add("NoVal");
        }
        return result;
    }
}

