/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.ui.generator;

import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.fortiss.af3.platform.baremetal.generator.BareMetalExecutable;
import org.fortiss.af3.platform.ui.AF3PlatformUIActivator;
import org.fortiss.af3.project.extension.base.ExecutionTargetBase;
import org.fortiss.af3.project.extension.data.Executable;
import org.fortiss.af3.project.ui.utils.FolderOrProjectDialogUtils;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class BareMetalGeneratorExecutionTarget
extends ExecutionTargetBase {
    public String getName() {
        return "Bare Metal Generator";
    }

    public Class<?> getExecutableClass() {
        return BareMetalExecutable.class;
    }

    protected void doExecute(Executable executable) {
        BareMetalExecutable exec = (BareMetalExecutable)executable.getExecutableObject();
        IFolder targetFolder = FolderOrProjectDialogUtils.openFolderDialog();
        if (targetFolder == null) {
            return;
        }
        try {
            String osString = targetFolder.getLocation().toOSString();
            exec.getSourcePackage().writeToLocation(osString);
            MessageUtilsExtended.showInfoInUIThread((String)"Bare Metal Generator", (String)("Bare metal deployment successfully generated into " + osString));
        }
        catch (IOException ioex) {
            LoggingUtils.error((Plugin)AF3PlatformUIActivator.getDefault(), (String)ioex.getMessage(), (Throwable)ioex);
        }
        try {
            targetFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException cex) {
            LoggingUtils.error((Plugin)AF3PlatformUIActivator.getDefault(), (String)cex.getMessage(), (Throwable)cex);
        }
    }
}

