/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.compose;

import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.project.compositor.FileProjectCompositor;
import org.fortiss.af3.project.model.FileProject;
import org.fortiss.af3.variability.featuremodel.model.AlternativeFeature;
import org.fortiss.af3.variability.featuremodel.model.CompositionalFeature;
import org.fortiss.af3.variability.featuremodel.model.CrossFeatureConstraint;
import org.fortiss.af3.variability.featuremodel.model.FeatureModel;
import org.fortiss.af3.variability.featuremodel.refactoring.FeatureNameRefactoringAdapter;
import org.fortiss.tooling.kernel.extension.base.ElementCompositorBase;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.features.AbstractFeatureModel;

public final class FeatureModelCompositors {
    private static void makeNamesUnique(EObject container, AbstractFeature newFeature) {
        AbstractFeatureModel featureModel = (AbstractFeatureModel)EcoreUtils.getFirstParentWithType((EObject)container, AbstractFeatureModel.class);
        if (container instanceof AbstractFeatureModel) {
            featureModel = (AbstractFeatureModel)container;
        }
        EList exisingFeatures = EcoreUtils.getChildrenWithType((EObject)featureModel, AbstractFeature.class);
        Set<String> existingNames = exisingFeatures.stream().map(f -> f.getName()).collect(Collectors.toSet());
        FeatureModelCompositors.makeFeatureNameUnique(newFeature, existingNames);
        if (newFeature instanceof AbstractAlternativeFeature) {
            AbstractAlternativeFeature newAlternativeFeature = (AbstractAlternativeFeature)newFeature;
            for (AbstractFeature alternative : newAlternativeFeature.getAlternatives()) {
                FeatureModelCompositors.makeFeatureNameUnique(alternative, existingNames);
            }
        }
    }

    private static void makeFeatureNameUnique(AbstractFeature newFeature, Set<String> existingNames) {
        Object newName = newFeature.getName().replaceAll("\\s", "");
        int num = 1;
        while (existingNames.contains(newName)) {
            newName = newFeature.getName() + num++;
        }
        newFeature.setName((String)newName);
        existingNames.add((String)newName);
    }

    public static class AlternativeFeatureCompositor
    extends FeatureCompositorBase<AlternativeFeature> {
        @Override
        public boolean doCompose(AlternativeFeature container, AbstractFeature feature, IElementCompositionContext context) {
            return container.getAlternatives().add((Object)feature);
        }
    }

    public static class CompositionalFeatureCompositor
    extends FeatureCompositorBase<CompositionalFeature> {
        @Override
        public boolean doCompose(CompositionalFeature container, AbstractFeature feature, IElementCompositionContext context) {
            return container.getSubFeatures().add((Object)feature);
        }
    }

    protected static abstract class FeatureCompositorBase<T extends AbstractFeature>
    extends ElementCompositorBase<T> {
        protected FeatureCompositorBase() {
        }

        protected boolean isCorrectClass(EObject contained) {
            return !(contained instanceof FeatureModel) && (contained instanceof AbstractFeature || contained instanceof CrossFeatureConstraint);
        }

        public final boolean compose(T container, EObject contained, IElementCompositionContext context) {
            if (contained instanceof CrossFeatureConstraint) {
                CrossFeatureConstraint constraint = (CrossFeatureConstraint)contained;
                return container.getConstraints().add((Object)constraint);
            }
            if (contained instanceof AbstractFeature) {
                AbstractFeature feature = (AbstractFeature)contained;
                FeatureModelCompositors.makeNamesUnique(container, feature);
                return this.doCompose(container, feature, context);
            }
            return false;
        }

        protected abstract boolean doCompose(T var1, AbstractFeature var2, IElementCompositionContext var3);
    }

    public static class FeatureModelCompositor
    extends ElementCompositorBase<FeatureModel> {
        public boolean compose(FeatureModel container, EObject contained, IElementCompositionContext context) {
            if (contained instanceof AbstractFeature) {
                AbstractFeature feature = (AbstractFeature)contained;
                FeatureModelCompositors.makeNamesUnique((EObject)container, feature);
                return container.getSubFeatures().add((Object)feature);
            }
            return false;
        }

        protected boolean isCorrectClass(EObject contained) {
            return contained instanceof AbstractFeature && !(contained instanceof FeatureModel);
        }

        public boolean canComposePrototype(Prototype prototype) {
            return prototype.getPrototype() instanceof CrossFeatureConstraint || super.canComposePrototype(prototype);
        }
    }

    public static class FeatureModelFileProjectCompositor
    extends FileProjectCompositor {
        protected boolean isCorrectElementClass(EObject contained) {
            return contained instanceof FeatureModel;
        }

        public boolean canCompose(FileProject container, EObject contained, IElementCompositionContext context) {
            return contained instanceof FeatureModel && !container.getRootElements().stream().anyMatch(pre -> pre instanceof FeatureModel);
        }

        public boolean compose(FileProject container, EObject contained, IElementCompositionContext context) {
            contained.eAdapters().add((Object)new FeatureNameRefactoringAdapter());
            return super.compose(container, contained, context);
        }
    }
}

