/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.constraint;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;
import org.fortiss.tooling.kernel.extension.base.ConstraintViolationBase;
import org.fortiss.tooling.kernel.extension.data.IConstraintViolation;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.util.VariabilityUtils;

public class FeatureNameConstraintChecker
extends ConstraintCheckerBase<AbstractFeature> {
    public boolean isApplicable(AbstractFeature modelElement) {
        return modelElement != null;
    }

    public List<? extends IConstraintViolation<? extends EObject>> apply(AbstractFeature modelElement) {
        String name = modelElement.getName();
        if (!VariabilityUtils.isNameLegalInPresenceCondition((String)name)) {
            String msg = "The feature name \"" + name + "\" is illegal! " + org.fortiss.tooling.ext.variability.util.VariabilityUtils.FEATURE_NAME_ERROR_MSG;
            return Collections.singletonList(new ConstraintViolationBase((EObject)modelElement, IConstraintViolation.ESeverity.ERROR, msg));
        }
        return Collections.emptyList();
    }
}

