/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.variability.featuremodel.refactoring;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.variability.featuremodel.model.AlternativeFeature;
import org.fortiss.af3.variability.featuremodel.model.CompositionalFeature;
import org.fortiss.af3.variability.featuremodel.model.FeatureModelModelElementFactory;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.variability.model.features.AbstractAlternativeFeature;
import org.fortiss.variability.model.features.AbstractCompositionalFeature;
import org.fortiss.variability.model.features.AbstractFeature;
import org.fortiss.variability.model.presence.PresenceCondition;
import org.fortiss.variability.model.presence.PresenceConditionTerm;

public class FeaturesRefactoringUtils {
    public static void renameFeatureInPresenceConditions(AbstractFeature feature, String oldName, String newName) {
        Collection references = EcoreUtils.getAllReferences((EObject)feature);
        Iterator iterator = references.iterator();
        while (iterator.hasNext()) {
            EObject ref;
            EObject parent = ref = (EObject)iterator.next();
            while (parent instanceof PresenceConditionTerm) {
                PresenceCondition term = (PresenceCondition)parent;
                String oldStr = term.getStringRepresentation();
                String newStr = oldStr.replaceAll("\\b" + oldName + "\\b", newName);
                term.setStringRepresentation(newStr);
                parent = parent.eContainer();
            }
        }
    }

    public static CompositionalFeature refactorAlternativeToCompositionalFeature(AbstractAlternativeFeature oldFeature) {
        CompositionalFeature newFeature = FeatureModelModelElementFactory.createCompositionalFeature(oldFeature.getName());
        EList alternatives = oldFeature.getAlternatives();
        newFeature.getSubFeatures().addAll((Collection)alternatives);
        newFeature.setOptional(oldFeature.isOptional());
        EcoreUtils.replaceEObjectReferences((EObject)oldFeature, (EObject)newFeature);
        EcoreUtil.replace((EObject)oldFeature, (EObject)newFeature);
        return newFeature;
    }

    public static AbstractFeature refactorCompositionalToAlternativeFeature(AbstractCompositionalFeature oldFeature) {
        AlternativeFeature newFeature = FeatureModelModelElementFactory.createAlternativeFeature(oldFeature.getName());
        EList subFeatures = oldFeature.getSubFeatures();
        newFeature.getAlternatives().addAll((Collection)subFeatures);
        newFeature.setOptional(oldFeature.isOptional());
        EcoreUtils.replaceEObjectReferences((EObject)oldFeature, (EObject)newFeature);
        EcoreUtil.replace((EObject)oldFeature, (EObject)newFeature);
        return newFeature;
    }
}

