/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.Theme;

public class DialStyler
extends Styler {
    private boolean isCircular;
    private boolean axisTicksMarksVisible;
    private Color axisTickMarksColor;
    private Stroke axisTickMarksStroke;
    private double[] axisTickValues = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
    private String[] axisTickLabels = new String[]{"0", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100"};
    private boolean axisTitleVisible;
    private Font axisTitleFont;
    private int axisTitlePadding;
    private boolean axisTickLabelsVisible = true;
    private double arcAngle = 270.0;
    private double donutThickness = 0.11;
    private double normalFrom = 0.0;
    private double normalTo = 1.0;
    private Color normalColor = Color.LIGHT_GRAY;
    private double greenFrom = 0.0;
    private double greenTo = 0.2;
    private Color greenColor = Color.GREEN;
    private double redFrom = 0.8;
    private double redTo = 1.0;
    private Color redColor = Color.RED;
    private double arrowLengthPercentage = 0.85;
    private double arrowArcAngle = 20.0;
    private double arrowArcPercentage = 0.15;

    public DialStyler() {
        this.setAllStyles();
    }

    @Override
    void setAllStyles() {
        this.isCircular = this.theme.isCircular();
        this.hasAnnotations = true;
        this.axisTickMarksColor = this.theme.getAxisTickMarksColor();
        this.axisTickMarksStroke = this.theme.getAxisTickMarksStroke();
        this.axisTicksMarksVisible = this.theme.isAxisTicksMarksVisible();
        this.axisTitleVisible = this.theme.isXAxisTitleVisible() || this.theme.isYAxisTitleVisible();
        this.axisTitleFont = this.theme.getAxisTitleFont();
        this.axisTitlePadding = this.theme.getAxisTitlePadding();
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public DialStyler setCircular(boolean isCircular) {
        this.isCircular = isCircular;
        return this;
    }

    public DialStyler setTheme(Theme theme) {
        this.theme = theme;
        super.setAllStyles();
        return this;
    }

    public boolean isAxisTicksMarksVisible() {
        return this.axisTicksMarksVisible;
    }

    public void setAxisTicksMarksVisible(boolean axisTicksMarksVisible) {
        this.axisTicksMarksVisible = axisTicksMarksVisible;
    }

    public Color getAxisTickMarksColor() {
        return this.axisTickMarksColor;
    }

    public void setAxisTickMarksColor(Color axisTickMarksColor) {
        this.axisTickMarksColor = axisTickMarksColor;
    }

    public Stroke getAxisTickMarksStroke() {
        return this.axisTickMarksStroke;
    }

    public void setAxisTickMarksStroke(Stroke axisTickMarksStroke) {
        this.axisTickMarksStroke = axisTickMarksStroke;
    }

    public boolean isAxisTitleVisible() {
        return this.axisTitleVisible;
    }

    public void setAxisTitleVisible(boolean axisTitleVisible) {
        this.axisTitleVisible = axisTitleVisible;
    }

    public Font getAxisTitleFont() {
        return this.axisTitleFont;
    }

    public void setAxisTitleFont(Font axisTitleFont) {
        this.axisTitleFont = axisTitleFont;
    }

    public int getAxisTitlePadding() {
        return this.axisTitlePadding;
    }

    public void setAxisTitlePadding(int axisTitlePadding) {
        this.axisTitlePadding = axisTitlePadding;
    }

    public double[] getAxisTickValues() {
        return this.axisTickValues;
    }

    public void setAxisTickValues(double[] axisTickValues) {
        this.axisTickValues = axisTickValues;
    }

    public String[] getAxisTickLabels() {
        return this.axisTickLabels;
    }

    public void setAxisTickLabels(String[] axisTickLabels) {
        this.axisTickLabels = axisTickLabels;
    }

    public double getNormalFrom() {
        return this.normalFrom;
    }

    public void setNormalFrom(double normalFrom) {
        this.normalFrom = normalFrom;
    }

    public double getNormalTo() {
        return this.normalTo;
    }

    public void setNormalTo(double normalTo) {
        this.normalTo = normalTo;
    }

    public Color getNormalColor() {
        return this.normalColor;
    }

    public void setNormalColor(Color normalColor) {
        this.normalColor = normalColor;
    }

    public double getGreenFrom() {
        return this.greenFrom;
    }

    public void setGreenFrom(double greenFrom) {
        this.greenFrom = greenFrom;
    }

    public double getGreenTo() {
        return this.greenTo;
    }

    public void setGreenTo(double greenTo) {
        this.greenTo = greenTo;
    }

    public Color getGreenColor() {
        return this.greenColor;
    }

    public void setGreenColor(Color greenColor) {
        this.greenColor = greenColor;
    }

    public double getRedFrom() {
        return this.redFrom;
    }

    public void setRedFrom(double redFrom) {
        this.redFrom = redFrom;
    }

    public double getRedTo() {
        return this.redTo;
    }

    public void setRedTo(double redTo) {
        this.redTo = redTo;
    }

    public Color getRedColor() {
        return this.redColor;
    }

    public void setRedColor(Color redColor) {
        this.redColor = redColor;
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public void setArcAngle(double arcAngle) {
        this.arcAngle = arcAngle;
    }

    public boolean isAxisTickLabelsVisible() {
        return this.axisTickLabelsVisible;
    }

    public void setAxisTickLabelsVisible(boolean axisTickLabelsVisible) {
        this.axisTickLabelsVisible = axisTickLabelsVisible;
    }

    public double getDonutThickness() {
        return this.donutThickness;
    }

    public void setDonutThickness(double donutThickness) {
        this.donutThickness = donutThickness;
    }

    public double getArrowLengthPercentage() {
        return this.arrowLengthPercentage;
    }

    public void setArrowLengthPercentage(double arrowLengthPercentage) {
        this.arrowLengthPercentage = arrowLengthPercentage;
    }

    public double getArrowArcAngle() {
        return this.arrowArcAngle;
    }

    public void setArrowArcAngle(double arrowArcAngle) {
        this.arrowArcAngle = arrowArcAngle;
    }

    public double getArrowArcPercentage() {
        return this.arrowArcPercentage;
    }

    public void setArrowArcPercentage(double arrowArcPercentage) {
        this.arrowArcPercentage = arrowArcPercentage;
    }
}

