/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.ff1.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.IncompleteArgumentException;
import org.apache.commons.lang.NullArgumentException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.model.AllocationTableCollection;
import org.fortiss.af3.ff1.generator.AF3FF1GeneratorActivator;
import org.fortiss.af3.ff1.generator.FF1FMUGenerator;
import org.fortiss.af3.ff1.generator.FF1ROSGenerator;
import org.fortiss.af3.generator.common.utils.FMUUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.project.extension.exception.ExecutablePreparationFailedException;
import org.fortiss.af3.project.extension.exception.ExecutionFailedException;
import org.fortiss.af3.task.model.Task;
import org.fortiss.af3.task.model.allocation.ComponentToTaskAllocationTable;
import org.fortiss.af3.task.model.allocation.TaskToExecutionUnitAllocationTable;
import org.fortiss.tooling.base.utils.SystemUtils;
import org.fortiss.tooling.kernel.ui.util.MessageUtilsExtended;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.osgi.framework.Bundle;

public class FF1Generator {
    private AllocationTableCollection atc;
    private HashMap<ExecutionUnit, String> executionUnitToHostnameMap;
    private ExecutionUnit master;
    private static final int MAX_NR_EXECUTION_UNITS = 3;
    private static final int DEPLOYMENT_SUBTASKS_FACTOR = 2;
    private static final int STARTUP_SUBTASKS_FACTOR = 1;
    private static String CONNECTIVITY_SCRIPT_PATH = "res/test_connectivity.bash";
    private static String DEPLOY_SCRIPT_PATH = "res/deploy.bash";
    private static String START_SCRIPT_PATH = "res/start.bash";
    private static String STOP_SCRIPT_PATH = "res/stop.bash";
    private static String LOG_SCRIPT_PATH = "res/print_log.bash";
    private int overallSubtasks;
    private int finishedSubtasks;
    private String outputWindowText;
    private Boolean finished;
    private IStatus jobStatus;
    private Job currentJob;
    private boolean toBeCanceled;
    private static final int PRE_STARTUP_SLEEP_SECONDS = 10;
    private static final int POST_STARTUP_SLEEP_SECONDS = 30;

    public FF1Generator(AllocationTableCollection atc, HashMap<ExecutionUnit, String> executionUnitToHostnameMap, ExecutionUnit master) {
        this.atc = atc;
        this.executionUnitToHostnameMap = executionUnitToHostnameMap;
        this.master = master;
        this.reset();
    }

    public void cancel() {
        this.toBeCanceled = true;
        this.currentJob.cancel();
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Cancel request was received and forwarded.\n\tWaiting for next safe cancelation moment (window will appear) ...\n\n";
    }

    public void run(final boolean stopMiddleware, final boolean deployFmus, final boolean startMiddleware) {
        IFolder fmuFolder;
        TaskToExecutionUnitAllocationTable tteuat;
        this.prepareNewRun(deployFmus);
        if (deployFmus) {
            this.overallSubtasks += this.executionUnitToHostnameMap.size() * 2;
        }
        if (startMiddleware || stopMiddleware) {
            this.overallSubtasks += this.executionUnitToHostnameMap.size() * 1;
        }
        if (this.toBeCanceled) {
            this.toBeCanceled = false;
            return;
        }
        if (deployFmus) {
            ComponentToTaskAllocationTable cttat = (ComponentToTaskAllocationTable)EcoreUtils.getFirstChildWithType((EObject)this.atc, ComponentToTaskAllocationTable.class);
            tteuat = (TaskToExecutionUnitAllocationTable)EcoreUtils.getFirstChildWithType((EObject)this.atc, TaskToExecutionUnitAllocationTable.class);
            try {
                fmuFolder = this.executeFmuGeneration(cttat, tteuat);
            }
            catch (Exception e) {
                this.handleException(e);
                return;
            }
        } else {
            tteuat = null;
            fmuFolder = null;
        }
        if (this.toBeCanceled) {
            this.toBeCanceled = false;
            return;
        }
        this.currentJob = new Job(String.format("FF1 Generator Run (Stop: [%B] - Deploy: [%B] - Start: [%B])", stopMiddleware, deployFmus, startMiddleware)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FF1Generator.this.runFF1Generator(stopMiddleware, deployFmus, startMiddleware, tteuat, fmuFolder);
                    FF1Generator.this.jobStatus = Status.OK_STATUS;
                }
                catch (Exception e) {
                    FF1Generator.this.handleException(e);
                    FF1Generator.this.jobStatus = Status.CANCEL_STATUS;
                }
                return FF1Generator.this.jobStatus;
            }
        };
        this.currentJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                FF1Generator.this.finished = true;
                FF1Generator.this.toBeCanceled = false;
            }
        });
        this.currentJob.setUser(true);
        this.currentJob.schedule();
    }

    private void handleException(Exception e) {
        e.printStackTrace();
        Object errorMessage = e.getMessage();
        if (errorMessage == null || ((String)errorMessage).isBlank()) {
            errorMessage = "No error message was given.\n\nCaught exception: " + e.toString();
        }
        MessageUtilsExtended.showInfoInUIThread((String)"Error", (String)errorMessage);
    }

    private void reset() {
        this.finished = false;
        this.overallSubtasks = 0;
        this.finishedSubtasks = 0;
        this.outputWindowText = "";
    }

    private void prepareNewRun(boolean fmuGenerationIncluded) {
        if (!SystemUtils.isLinuxPlatform()) {
            throw new RuntimeException("This feature is only available for Linux systems.");
        }
        this.reset();
        this.overallSubtasks = 1;
        if (fmuGenerationIncluded) {
            this.overallSubtasks += 2;
        }
    }

    private void runFF1Generator(boolean stopMiddleware, boolean deployFmus, boolean startMiddleware, TaskToExecutionUnitAllocationTable tteuat, IFolder fmuFolder) throws IOException, InterruptedException, CancellationException {
        this.outputWindowText = String.valueOf(this.outputWindowText) + String.format("\n[FF1 Generator] Executing 'Run with Stop=%B and Deploy=%B and Start=%B'\n", stopMiddleware, deployFmus, startMiddleware);
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Checking connectivity by pinging Pis ...\n";
        String executionUnits = Arrays.toString(this.executionUnitToHostnameMap.values().toArray()).replace("[", "").replace("]", "").replace(",", "");
        this.checkPisConnectivity(executionUnits);
        ++this.finishedSubtasks;
        this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] Connectivity checked. Ping and SSH operations where successfully tested.\n";
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        if (stopMiddleware) {
            this.stopMiddleware();
            this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] Middleware was stopped.\n";
        }
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        if (deployFmus) {
            this.executeDeployment(tteuat, fmuFolder);
            this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] Deployment was executed.\n";
        }
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        if (startMiddleware) {
            this.startMiddleware();
            this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] Middleware was started.\n";
        }
    }

    private IFolder executeFmuGeneration(ComponentToTaskAllocationTable cttat, TaskToExecutionUnitAllocationTable tteuat) throws ExecutablePreparationFailedException, ExecutionFailedException, CancellationException {
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Executing 'generate FMUs for middleware'\n";
        this.checkProject(cttat, tteuat);
        ++this.finishedSubtasks;
        this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] Project checked. The given AllocationTableCollection can be exported.\n";
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        IFolder fmuFolder = FF1FMUGenerator.generateFMUs(cttat);
        if (fmuFolder == null) {
            this.finished = true;
            throw new NullArgumentException("No target folder for the FMUs was chosen.");
        }
        ++this.finishedSubtasks;
        this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] FMUs were generated in the specified location.\n";
        return fmuFolder;
    }

    private void executeDeployment(TaskToExecutionUnitAllocationTable tteuat, IFolder fmuFolder) throws IOException, InterruptedException, CancellationException {
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Executing 'deploy FMUs on middleware'\n";
        String sourceFolderPath = fmuFolder.getLocation().toString();
        Collection taskList = tteuat.getTasks().stream().map(task -> FMUUtils.toLegalName((String)task.getName()) + ".fmu").collect(Collectors.toCollection(ArrayList::new));
        String tasks = Arrays.toString(taskList.toArray()).replace("[", "").replace("]", "").replace(",", "");
        for (ExecutionUnit executionUnit : this.executionUnitToHostnameMap.keySet()) {
            if (this.toBeCanceled) {
                throw new CancellationException("The current job was canceled.");
            }
            boolean isMaster = executionUnit.equals(this.master);
            FF1ROSGenerator.generateROSLaunchFile(executionUnit, (EList<Task>)tteuat.getTasks(executionUnit), sourceFolderPath, isMaster, this.executionUnitToHostnameMap.get(executionUnit));
            ++this.finishedSubtasks;
            this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] ROS launch file for " + executionUnit.getName() + " generated successfully.\n";
            int exitCode = this.deployOnRover(this.executionUnitToHostnameMap.get(executionUnit), sourceFolderPath, tasks, executionUnit);
            if (exitCode == 0) continue;
            this.finished = true;
            throw new RuntimeException("Deployment failed. Model can not be executed on the fortissimo rover.\nExit code: " + exitCode);
        }
    }

    private void startMiddleware() throws IOException, InterruptedException, CancellationException {
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Executing 'start middleware on rover'\n";
        String masterHostname = this.executionUnitToHostnameMap.get(this.master);
        int exitCode = this.startMiddlewareOnRover(masterHostname);
        if (exitCode != 0) {
            throw new RuntimeException("Startup failed. Model cannot be executed on the fortissimo rover (master).\nExit code: " + exitCode);
        }
        TimeUnit.SECONDS.sleep(10L);
        for (ExecutionUnit executionUnit : this.executionUnitToHostnameMap.keySet()) {
            if (this.toBeCanceled) {
                throw new CancellationException("The current job was canceled.");
            }
            boolean isMaster = executionUnit.equals(this.master);
            if (isMaster || (exitCode = this.startMiddlewareOnRover(this.executionUnitToHostnameMap.get(executionUnit))) == 0) continue;
            throw new RuntimeException("Startup failed. Model cannot be executed on the fortissimo rover (slaves).\nExit code: " + exitCode);
        }
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        exitCode = this.printLogAfterStartup(masterHostname);
        if (exitCode != 0) {
            this.finished = true;
            throw new RuntimeException("Log could not be printed.\nExit code: " + exitCode);
        }
    }

    private void stopMiddleware() throws IOException, InterruptedException, CancellationException {
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Executing 'stop middleware on rover'\n";
        for (ExecutionUnit executionUnit : this.executionUnitToHostnameMap.keySet()) {
            int exitCode;
            if (this.toBeCanceled) {
                throw new CancellationException("The current job was canceled.");
            }
            boolean isMaster = executionUnit.equals(this.master);
            if (isMaster || (exitCode = this.stopMiddlewareOnRover(this.executionUnitToHostnameMap.get(executionUnit))) == 0) continue;
            throw new RuntimeException("Stopping middleware (slaves) on rover has failed.\nExit code: " + exitCode);
        }
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        String masterHostname = this.executionUnitToHostnameMap.get(this.master);
        int exitCode = this.stopMiddlewareOnRover(masterHostname);
        if (exitCode != 0) {
            throw new RuntimeException("Stopping middleware (master) on rover has failed.\nExit code: " + exitCode);
        }
    }

    private int printLogAfterStartup(String host) throws InterruptedException, IOException {
        this.outputWindowText = String.valueOf(this.outputWindowText) + "\n[FF1 Generator] Waiting for startup...\n";
        this.outputWindowText = String.valueOf(this.outputWindowText) + "[FF1 Generator] Next lines will first be displayed in ...\n";
        int i = 30;
        while (i > 0) {
            this.outputWindowText = String.valueOf(this.outputWindowText) + i + " seconds\n";
            TimeUnit.SECONDS.sleep(1L);
            --i;
        }
        String scriptPath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)AF3FF1GeneratorActivator.PLUGIN_ID), (IPath)new Path(LOG_SCRIPT_PATH), null)).getPath();
        String[] printLogCommand = new String[]{"/bin/bash", scriptPath, host};
        return this.executeProcess(printLogCommand);
    }

    private int deployOnRover(String host, String sourceFolderPath, String tasks, ExecutionUnit executionUnit) throws IOException, InterruptedException {
        String scriptPath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)AF3FF1GeneratorActivator.PLUGIN_ID), (IPath)new Path(DEPLOY_SCRIPT_PATH), null)).getPath();
        String launchFileName = "ff1_middleware_" + FMUUtils.toLegalName((String)executionUnit.getName()) + ".launch.py";
        String[] deployCommand = new String[]{"/bin/bash", scriptPath, host, sourceFolderPath, launchFileName, tasks};
        return this.executeProcess(deployCommand);
    }

    private int startMiddlewareOnRover(String host) throws IOException, InterruptedException {
        String scriptPath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)AF3FF1GeneratorActivator.PLUGIN_ID), (IPath)new Path(START_SCRIPT_PATH), null)).getPath();
        String[] startCommand = new String[]{"/bin/bash", scriptPath, host};
        return this.executeProcess(startCommand);
    }

    private int stopMiddlewareOnRover(String host) throws IOException, InterruptedException {
        String scriptPath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)AF3FF1GeneratorActivator.PLUGIN_ID), (IPath)new Path(STOP_SCRIPT_PATH), null)).getPath();
        String[] stopCommand = new String[]{"/bin/bash", scriptPath, host};
        return this.executeProcess(stopCommand);
    }

    private int executeProcess(String[] command) throws IOException, InterruptedException {
        int exitCode = 1;
        Process p = Runtime.getRuntime().exec(command);
        p.waitFor();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            this.outputWindowText = String.valueOf(this.outputWindowText) + s + "\n";
        }
        while ((s = stdError.readLine()) != null) {
            this.outputWindowText = String.valueOf(this.outputWindowText) + s + "\n";
        }
        exitCode = p.exitValue();
        p.destroy();
        if (exitCode == 0) {
            ++this.finishedSubtasks;
        }
        return exitCode;
    }

    private void checkProject(ComponentToTaskAllocationTable cttat, TaskToExecutionUnitAllocationTable tteuat) {
        if (cttat == null || tteuat == null) {
            throw new IncompleteArgumentException("The FF1 generator requires a component architecture, a task architecture, a platform architecture, and allocation tables specifying the mapping of the models' elements.");
        }
        if (tteuat.getExecutionUnits().size() > 3) {
            throw new IllegalArgumentException("The maximum number of execution units available for deployment (3) has been exceeded.");
        }
    }

    private void checkPisConnectivity(String executionUnits) throws IOException, InterruptedException {
        String scriptPath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)AF3FF1GeneratorActivator.PLUGIN_ID), (IPath)new Path(CONNECTIVITY_SCRIPT_PATH), null)).getPath();
        String[] checkCommand = new String[]{"/bin/bash", scriptPath, executionUnits};
        if (this.toBeCanceled) {
            throw new CancellationException("The current job was canceled.");
        }
        int exitCode = this.executeProcess(checkCommand);
        if (exitCode != 0) {
            this.finished = true;
            if (exitCode == 255) {
                throw new RuntimeException("Deployment failed due to connectivity issues: SSH connection is unsuccessful. You should probably check the .ssh/config file.\nExit code: " + exitCode);
            }
            throw new RuntimeException("Deployment failed due to connectivity issues: Ping is unsuccessful.\nExit code: " + exitCode);
        }
    }

    public static EList<ExecutionUnit> getExecutionUnits(AllocationTableCollection atc) {
        TaskToExecutionUnitAllocationTable tteuat = (TaskToExecutionUnitAllocationTable)EcoreUtils.getFirstChildWithType((EObject)atc, TaskToExecutionUnitAllocationTable.class);
        if (tteuat == null) {
            return null;
        }
        return tteuat.getExecutionUnits();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public double getFinishedSubtasks() {
        return this.finishedSubtasks;
    }

    public double getOverallSubtasks() {
        return this.overallSubtasks;
    }

    public String getOutputWindowText() {
        return this.outputWindowText;
    }

    public IStatus getJobStatus() {
        return this.jobStatus;
    }
}

