/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.ff1.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang.NullArgumentException;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.generator.common.utils.FMUUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.task.model.Task;

public class FF1ROSGenerator {
    public static void generateROSLaunchFile(ExecutionUnit executionUnit, EList<Task> tasks, String folderName, Boolean isMaster, String host) throws IOException {
        String fileName = "ff1_middleware_" + FMUUtils.toLegalName((String)executionUnit.getName()) + ".launch.py";
        String namespace = FF1ROSGenerator.removeLastChar(host);
        if (namespace == null) {
            throw new NullArgumentException("Hostname could not be parsed. Make sure hostname follows the given naming conventions.");
        }
        String taskNodes = FF1ROSGenerator.generateTaskNodes(tasks, namespace);
        PrintWriter printWriter = new PrintWriter(new FileWriter(folderName + File.separator + fileName));
        printWriter.print("from launch import LaunchDescription\n");
        printWriter.print("from launch_ros.actions import Node\n");
        printWriter.print("json_path = \"/home/ubuntu/colcon_ws/src/ff1_middleware/share/config.json\"\n");
        printWriter.print("synchronous = False\n");
        printWriter.print("debug = True\n");
        printWriter.print("def generate_launch_description():\n");
        printWriter.print("\treturn LaunchDescription([\n");
        printWriter.print(taskNodes);
        if (isMaster.booleanValue()) {
            printWriter.print(String.format("\t\tNode(name='ff1_middleware_node', package='ff1_middleware', namespace='%s', executable='ff1_middleware_node', output='screen', parameters=[{'json_config_path': json_path, 'rover_config_file': \"/etc/ff1/config.yaml\"}], arguments=['--ros-args', '--log-level', 'INFO'],),\n", namespace));
            printWriter.print(String.format("\t\tNode(name='master', package='rosco', namespace='%s', executable='master', output='screen', parameters=[{'synchronous': synchronous, 'debug': debug}], arguments=['--ros-args', '--log-level', 'INFO'],),\n", namespace));
            printWriter.print(String.format("\t\tNode(name='adapter', package='rosco', namespace='%s', executable='adapter', output='screen', parameters=[{'json_config_path': json_path}], arguments=['--ros-args', '--log-level', 'INFO'],),\n", namespace));
        }
        printWriter.print("\t])\n");
        printWriter.close();
    }

    private static String generateTaskNodes(EList<Task> tasks, String namespace) {
        Object nodes = "";
        for (Task task : tasks) {
            nodes = (String)nodes + String.format("\t\tNode(name='%s', package='rosco', namespace='%s', executable='slave', output='screen', arguments=['--ros-args', '--log-level', 'INFO'],),\n", FMUUtils.toLegalName((String)task.getName()), namespace);
        }
        return nodes;
    }

    private static String removeLastChar(String s) {
        return s == null || s.isEmpty() ? null : s.substring(0, s.length() - 1);
    }
}

