/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.compose;

import java.util.Collection;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeComponentStructureSpecification;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.model.SwitchSegmentEntryConnector;
import org.fortiss.af3.mode.model.SwitchSegmentExitConnector;
import org.fortiss.af3.mode.utils.ModeAutomatonUtils;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.compose.HierarchicElementCompositorBase;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.base.ConnectorBase;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.EllipseLayoutUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.RectangleLayoutUtils;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ModeCompositor
extends HierarchicElementCompositorBase<Mode> {
    public boolean canCompose(Mode container, EObject contained, IElementCompositionContext context) {
        if (ModeAutomatonUtils.getModeAutomaton(container) == null) {
            return this.isCorrectElementClass(contained) && ReflectionUtils.pickInstanceOf(contained.getClass(), (Collection)container.getSpecifications()) == null;
        }
        Mode rootMode = ModeAutomatonUtils.getModeAutomaton(container).getRootMode();
        if (container.equals(rootMode)) {
            return ReflectionUtils.isInstanceOfAny((Object)contained, (Class[])new Class[]{Mode.class, SwitchSegmentExitConnector.class, SwitchSegmentEntryConnector.class, SwitchSegment.class});
        }
        if (container.getModeComponentStructureSpecification() != null) {
            return ReflectionUtils.isInstanceOfAny((Object)contained, (Class[])new Class[]{SwitchSegmentExitConnector.class, SwitchSegmentEntryConnector.class, SwitchSegment.class});
        }
        if (!container.getSubModes().isEmpty()) {
            return ReflectionUtils.isInstanceOfAny((Object)contained, (Class[])new Class[]{Mode.class, SwitchSegmentExitConnector.class, SwitchSegmentEntryConnector.class, SwitchSegment.class});
        }
        return this.isCorrectElementClass(contained) && ReflectionUtils.pickInstanceOf(contained.getClass(), (Collection)container.getSpecifications()) == null;
    }

    public boolean compose(Mode container, EObject contained, IElementCompositionContext context) {
        super.compose((EObject)container, contained, context);
        if (contained instanceof Mode) {
            Mode mode = (Mode)contained;
            LayoutDataUtils.layoutModelElement((EObject)mode, (IElementCompositionContext)context);
            container.getContainedElements().add((Object)mode);
            return true;
        }
        if (contained instanceof ConnectorBase) {
            ConnectorBase connector = (ConnectorBase)contained;
            if (context instanceof ElementDropContext) {
                ElementDropContext ctx = (ElementDropContext)context;
                if (ctx.isRoot()) {
                    RectangleLayoutUtils.layoutNodeInRoot((ILayoutedModelElement)connector, (ElementDropContext)ctx, (int)12, (boolean)true);
                } else {
                    EllipseLayoutUtils.layoutConnectorInEllipse((ILayoutedModelElement)connector, (ILayoutedModelElement)container, (Point)ctx.getPosition());
                }
            }
            container.getConnectors().add((Object)connector);
            return true;
        }
        if (contained instanceof ModeComponentStructureSpecification) {
            ModeComponentStructureSpecification mcss = (ModeComponentStructureSpecification)contained;
            Component superComponent = ModeAutomatonUtils.getSuperComponent(container);
            for (InputPort input : superComponent.getInputPorts()) {
                InputPort newInput = ComponentModelElementFactory.createInputPort((String)input.getName(), (String)input.getComment(), (IType)((IType)EcoreUtils.copy((EObject)input.getPortSpecification().getType())), (IExpressionTerm)((IExpressionTerm)EcoreUtils.copy((EObject)input.getPortSpecification().getInitialValue())));
                if (mcss.getTopComponent().findInputPort(input.getName()) != null) continue;
                mcss.getTopComponent().getConnectors().add((Object)newInput);
            }
            for (OutputPort output : superComponent.getOutputPorts()) {
                IType typeCopy = (IType)EcoreUtils.copy((EObject)output.getPortSpecification().getType());
                IExpressionTerm initCopy = (IExpressionTerm)EcoreUtils.copy((EObject)output.getPortSpecification().getInitialValue());
                String comment = output.getComment();
                OutputPort newOut = ComponentModelElementFactory.createOutputPort((String)output.getName(), (String)comment, (IType)typeCopy, (IExpressionTerm)initCopy);
                if (mcss.getTopComponent().findOutputPort(output.getName()) != null) continue;
                mcss.getTopComponent().getConnectors().add((Object)newOut);
            }
            container.getSpecifications().add((Object)mcss);
            return true;
        }
        return false;
    }

    public boolean canComposePrototype(Prototype prototype) {
        return this.isCorrectElementClass(prototype.getPrototype());
    }

    public boolean canDecompose(EObject contained) {
        return this.isCorrectElementClass(contained);
    }

    private boolean isCorrectElementClass(EObject element) {
        return ReflectionUtils.isInstanceOfAny((Object)element, (Class[])new Class[]{Mode.class, SwitchSegmentExitConnector.class, SwitchSegmentEntryConnector.class, SwitchSegment.class, ModeComponentStructureSpecification.class});
    }
}

