/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.constraint;

import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.mode.constraint.ModeAutomatonConstraintViolation;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.ModeComponentStructureSpecification;

public class ConstraintMessage {
    public static ModeAutomatonConstraintViolation<ModeAutomaton> createNoneInitialModeViolation(ModeAutomaton automaton) {
        return new ModeAutomatonConstraintViolation<ModeAutomaton>(automaton, "Mode Automata of " + String.valueOf(automaton.getContainerComponent()) + " has none intial mode!");
    }

    public static ModeAutomatonConstraintViolation<ModeComponentStructureSpecification> createInvalidPortViolation(Component superComponentOfModeAutomaton, ModeComponentStructureSpecification mcss, Port port) {
        String portType = "";
        portType = port instanceof InputPort ? "Input port " : "Output port ";
        return new ModeAutomatonConstraintViolation<ModeComponentStructureSpecification>(mcss, portType + port.getName() + " is not contained in its super component " + superComponentOfModeAutomaton.getName());
    }

    public static ModeAutomatonConstraintViolation<ModeComponentStructureSpecification> createPortTypeMismatchViolation(Component superComponentOfModeAutomaton, ModeComponentStructureSpecification mcss, Port port, Port origPort) {
        return new ModeAutomatonConstraintViolation<ModeComponentStructureSpecification>(mcss, "Type mismatch in port " + port.getName() + " with its source port " + origPort.getName() + " of component " + superComponentOfModeAutomaton.getName());
    }

    public static ModeAutomatonConstraintViolation<ModeComponentStructureSpecification> createInitialValueMismatchViolation(Component superComponentOfModeAutomaton, ModeComponentStructureSpecification mcss, Port port, Port origPort) {
        return new ModeAutomatonConstraintViolation<ModeComponentStructureSpecification>(mcss, "Initial value mismatch in port " + port.getName() + " with its source port " + origPort.getName() + " of component " + superComponentOfModeAutomaton.getName());
    }

    public static ModeAutomatonConstraintViolation<Mode> createModeSubStructureViolation(Mode mode) {
        String message = " must have a sub component structure or a set of sub modes!";
        return new ModeAutomatonConstraintViolation<Mode>(mode, "Mode " + mode.getName() + message);
    }
}

