/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.constraint;

import java.util.ArrayList;
import java.util.List;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.mode.constraint.ConstraintMessage;
import org.fortiss.af3.mode.constraint.ModeAutomatonConstraintViolation;
import org.fortiss.af3.mode.model.ModeComponentStructureSpecification;
import org.fortiss.af3.mode.utils.ModeAutomatonUtils;
import org.fortiss.tooling.kernel.extension.base.ConstraintCheckerBase;

public class ModeComponentStructurePortsChecker
extends ConstraintCheckerBase<ModeComponentStructureSpecification> {
    public List<ModeAutomatonConstraintViolation<ModeComponentStructureSpecification>> apply(ModeComponentStructureSpecification mcss) {
        ArrayList<ModeAutomatonConstraintViolation<ModeComponentStructureSpecification>> result = new ArrayList<ModeAutomatonConstraintViolation<ModeComponentStructureSpecification>>();
        Component topComponentOfStructure = mcss.getTopComponent();
        Component superComponentOfModeAutomaton = ModeAutomatonUtils.getSuperComponent(mcss.getContainerMode());
        for (InputPort in : topComponentOfStructure.getInputPorts()) {
            if (superComponentOfModeAutomaton.findInputPort(in.getName()) == null) {
                result.add(ConstraintMessage.createInvalidPortViolation(superComponentOfModeAutomaton, mcss, (Port)in));
                continue;
            }
            InputPort tmpInput = superComponentOfModeAutomaton.findInputPort(in.getName());
            if (!in.getVariableType().equals(tmpInput.getVariableType())) {
                result.add(ConstraintMessage.createPortTypeMismatchViolation(superComponentOfModeAutomaton, mcss, (Port)in, (Port)tmpInput));
            }
            if (!mcss.getContainerMode().isInitial() || in.getInitialValue() == null || tmpInput.getInitialValue() == null || in.getInitialValue().equals(tmpInput.getInitialValue())) continue;
            result.add(ConstraintMessage.createInitialValueMismatchViolation(superComponentOfModeAutomaton, mcss, (Port)in, (Port)tmpInput));
        }
        for (OutputPort out : topComponentOfStructure.getOutputPorts()) {
            if (superComponentOfModeAutomaton.findOutputPort(out.getName()) == null) {
                result.add(ConstraintMessage.createInvalidPortViolation(superComponentOfModeAutomaton, mcss, (Port)out));
                continue;
            }
            OutputPort tmpOutput = superComponentOfModeAutomaton.findOutputPort(out.getName());
            if (!out.getVariableType().equals(tmpOutput.getVariableType())) {
                result.add(ConstraintMessage.createPortTypeMismatchViolation(superComponentOfModeAutomaton, mcss, (Port)out, (Port)tmpOutput));
            }
            if (!mcss.getContainerMode().isInitial() || out.getInitialValue() == null || tmpOutput.getInitialValue() == null || out.getInitialValue().equals(tmpOutput.getInitialValue())) continue;
            result.add(ConstraintMessage.createInitialValueMismatchViolation(superComponentOfModeAutomaton, mcss, (Port)out, (Port)tmpOutput));
        }
        if (result.size() != 0) {
            return result;
        }
        return null;
    }
}

