/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.generator.component;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.generator.component.ComponentFunctionIdentifierUtils;
import org.fortiss.af3.component.generator.component.ComponentProgramTransformationBase;
import org.fortiss.af3.component.generator.component.PortVariableUtils;
import org.fortiss.af3.component.generator.component.TermReplacement;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.Port;
import org.fortiss.af3.component.model.generator.ComponentProgram;
import org.fortiss.af3.component.model.generator.LocalFunction;
import org.fortiss.af3.component.model.generator.LocalVariable;
import org.fortiss.af3.component.utils.GeneratorModelElementFactory;
import org.fortiss.af3.expression.model.terms.FunctionCall;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.expression.model.terms.imperative.Assignment;
import org.fortiss.af3.expression.model.terms.imperative.IStatementTerm;
import org.fortiss.af3.expression.model.terms.imperative.IfThenElse;
import org.fortiss.af3.expression.model.terms.imperative.Return;
import org.fortiss.af3.expression.model.terms.imperative.StatementSequence;
import org.fortiss.af3.expression.utils.ExpressionModelElementFactory;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.model.SwitchSegmentConnector;
import org.fortiss.af3.mode.model.SwitchSegmentSpecification;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.IdentifierUtils;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class ModeAutomatonTransformation
extends ComponentProgramTransformationBase {
    public static final String CURRENT_MODE_VAR_NAME = "current_mode";
    public static final String NEXT_MODE_VAR_NAME = "next_mode";
    private static final String MODE_FIRE_FUNCTION_NAME_PREFIX = "fire_mode_";
    private static final String SWITCH_SEGMENT_FIRE_FUNCTION_NAME_PREFIX = "fire_switch_segment_";

    public ComponentProgram transform(Object source, ITransformationContext context) throws TransformationFailedException {
        ComponentProgram program = super.transform(source, context);
        ModeAutomaton automaton = this.getSpecification((Component)source);
        for (Mode subMode : automaton.getRootMode().getSubModes()) {
            Component modeRoot = subMode.getModeComponentStructureSpecification().getTopComponent();
            ComponentProgram subProg = (ComponentProgram)TransformationUtils.createTransformedObjectFor((EObject)modeRoot, ComponentProgram.class, (ITransformationContext)context);
            program.getSubPrograms().add((Object)subProg);
        }
        return program;
    }

    protected List<LocalVariable> createLocalVariables(Component component) {
        ArrayList<LocalVariable> vars = new ArrayList<LocalVariable>();
        vars.add(GeneratorModelElementFactory.createLocalVariable((String)CURRENT_MODE_VAR_NAME, (IType)ExpressionModelElementFactory.intType()));
        vars.add(GeneratorModelElementFactory.createLocalVariable((String)NEXT_MODE_VAR_NAME, (IType)ExpressionModelElementFactory.intType()));
        return vars;
    }

    protected StatementSequence createInitialization(Component component) {
        ModeAutomaton automaton = this.getSpecification(component);
        StatementSequence result = super.createPortInitialization(component);
        Mode initialMode = automaton.getInitialMode();
        result.getStatements().add((Object)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_MODE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)initialMode.getId())));
        result.getStatements().add((Object)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)NEXT_MODE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)initialMode.getId())));
        Component modeComponent = initialMode.getModeComponentStructureSpecification().getTopComponent();
        result.getStatements().add((Object)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getInitializeFunctionName((Component)modeComponent)));
        return result;
    }

    protected List<LocalFunction> createLocalFunctions(Component component) {
        ArrayList<LocalFunction> funs = new ArrayList<LocalFunction>();
        ModeAutomaton automaton = this.getSpecification(component);
        for (IConnection seg : automaton.getRootMode().getConnections()) {
            funs.add(this.createSwitchSegmentFireFunction(component, (SwitchSegment)seg));
        }
        for (Mode mode : automaton.getRootMode().getSubModes()) {
            funs.add(this.createModeFireFunction(mode));
        }
        return funs;
    }

    protected StatementSequence createPerformStep(Component component) {
        ModeAutomaton automaton = this.getSpecification(component);
        ArrayList<Object> body = new ArrayList<Object>();
        body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getClearOutputsFunctionName((Component)component))));
        IfThenElse lastBlock = null;
        for (Mode mode : automaton.getRootMode().getSubModes()) {
            FunctionCall guard = ExpressionModelElementFactory.equal((IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_MODE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)mode.getId()));
            LinkedList<IStatementTerm> modeExecution = new LinkedList<IStatementTerm>();
            this.createModeExecutionCode(component, mode.getModeComponentStructureSpecification().getTopComponent(), modeExecution);
            IfThenElse ifte = ExpressionModelElementFactory.ifthenelse((IExpressionTerm)ExpressionModelElementFactory.not((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ModeAutomatonTransformation.getModeFireFunctionName(mode))), (StatementSequence)ExpressionModelElementFactory.sequence(modeExecution), null);
            lastBlock = lastBlock == null ? ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)ifte), null) : ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)ifte), (StatementSequence)ExpressionModelElementFactory.sequence(lastBlock));
        }
        if (lastBlock != null) {
            body.add(lastBlock);
        }
        return ExpressionModelElementFactory.sequence(body);
    }

    protected boolean canTransformComponent(Component source, ITransformationContext context) {
        return this.getSpecification(source) != null;
    }

    public static String getModeFireFunctionName(Mode m) {
        return MODE_FIRE_FUNCTION_NAME_PREFIX + IdentifierUtils.getUniqueIdentifier((INamedElement)m);
    }

    public static String getSwitchSegmentFireFunctionName(SwitchSegment s) {
        return SWITCH_SEGMENT_FIRE_FUNCTION_NAME_PREFIX + IdentifierUtils.getUniqueIdentifier((INamedElement)s);
    }

    private LocalFunction createSwitchSegmentFireFunction(Component modeAutomatonComponent, SwitchSegment segment) {
        StatementSequence seq;
        SwitchSegmentSpecification spec = segment.getSwitchSegmentSpecification();
        Mode nextMode = segment.getTargetConnector().getMode();
        Component nextModeRootComponent = nextMode.getModeComponentStructureSpecification().getTopComponent();
        AbstractList body = new LinkedList<Assignment>();
        FunctionCall guard = ExpressionModelElementFactory.notEqual((IExpressionTerm)ExpressionModelElementFactory.createVar((String)NEXT_MODE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_MODE_VAR_NAME));
        body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)CURRENT_MODE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.createVar((String)NEXT_MODE_VAR_NAME)));
        body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getInitializeFunctionName((Component)nextModeRootComponent))));
        IfThenElse ifte = ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence(body), null);
        body = new ArrayList();
        body.add(ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.createVar((String)NEXT_MODE_VAR_NAME), (IExpressionTerm)ExpressionModelElementFactory.intConst((int)nextMode.getId())));
        body.add(ifte);
        this.createModeExecutionCode(modeAutomatonComponent, nextModeRootComponent, body);
        body.add(ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)true)));
        if (spec.getGuard() == null) {
            guard = ExpressionModelElementFactory.boolConst((boolean)true);
            seq = ExpressionModelElementFactory.sequence((List)body);
        } else {
            guard = spec.getGuard().getExpression();
            guard = (IExpressionTerm)new TermReplacement((ITerm)guard).apply();
            seq = ExpressionModelElementFactory.sequence((IStatementTerm)ExpressionModelElementFactory.ifthenelse((IExpressionTerm)guard, (StatementSequence)ExpressionModelElementFactory.sequence((List)body), (StatementSequence)ExpressionModelElementFactory.sequence((IStatementTerm)ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)false)))));
        }
        return GeneratorModelElementFactory.createLocalFunction((String)ModeAutomatonTransformation.getSwitchSegmentFireFunctionName(segment), (IType)ExpressionModelElementFactory.boolType(), (StatementSequence)seq);
    }

    private void createModeExecutionCode(Component automatonComponent, Component nextModeComponent, List<IStatementTerm> body) {
        for (InputPort inport : nextModeComponent.getInputPorts()) {
            InputPort source = automatonComponent.findInputPort(inport.getName());
            body.add((IStatementTerm)PortVariableUtils.getPortPortValueAssignment((Port)source, (Port)inport));
        }
        body.add((IStatementTerm)ExpressionModelElementFactory.assignment((IExpressionTerm)ExpressionModelElementFactory.funcCall((String)ComponentFunctionIdentifierUtils.getPerformStepFunctionName((Component)nextModeComponent))));
        for (OutputPort outport : nextModeComponent.getOutputPorts()) {
            OutputPort target = automatonComponent.findOutputPort(outport.getName());
            body.add((IStatementTerm)PortVariableUtils.getPortPortValueAssignment((Port)outport, (Port)target));
        }
    }

    private LocalFunction createModeFireFunction(Mode m) {
        LinkedList<SwitchSegment> segments = new LinkedList<SwitchSegment>();
        for (SwitchSegmentConnector tsc : m.getSwitchSegmentExitConnectors()) {
            segments.addAll((Collection<SwitchSegment>)tsc.getOutgoingSwitchSegment());
        }
        LinkedList<Return> body = new LinkedList<Return>();
        if (!segments.isEmpty()) {
            body.add(ExpressionModelElementFactory.returns((IExpressionTerm)this.getOrCascade(segments)));
        } else {
            body.add(ExpressionModelElementFactory.returns((IExpressionTerm)ExpressionModelElementFactory.boolConst((boolean)false)));
        }
        return GeneratorModelElementFactory.createLocalFunction((String)ModeAutomatonTransformation.getModeFireFunctionName(m), (IType)ExpressionModelElementFactory.boolType(), (StatementSequence)ExpressionModelElementFactory.sequence(body));
    }

    private IExpressionTerm getOrCascade(LinkedList<SwitchSegment> segments) {
        FunctionCall cascade = ExpressionModelElementFactory.funcCall((String)ModeAutomatonTransformation.getSwitchSegmentFireFunctionName(segments.getLast()));
        ListIterator<SwitchSegment> it = segments.listIterator(segments.size() - 1);
        while (it.hasPrevious()) {
            FunctionCall funCall = ExpressionModelElementFactory.funcCall((String)ModeAutomatonTransformation.getSwitchSegmentFireFunctionName(it.previous()));
            cascade = ExpressionModelElementFactory.or((IExpressionTerm)funCall, (IExpressionTerm)cascade);
        }
        return cascade;
    }

    private ModeAutomaton getSpecification(Component source) {
        return (ModeAutomaton)ReflectionUtils.pickInstanceOf(ModeAutomaton.class, (Collection)source.getSpecifications());
    }
}

