/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.simulator;

import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.InputPort;
import org.fortiss.af3.component.model.OutputPort;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.simulator.ExecutableAtomicComponentBase;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.simulator.ExecutionException;
import org.fortiss.af3.component.simulator.SignalSource;
import org.fortiss.af3.expression.language.evaluation.BoolValue;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.model.SwitchSegmentConnector;
import org.fortiss.af3.mode.model.SwitchSegmentExitConnector;
import org.fortiss.af3.mode.model.SwitchSegmentSpecification;
import org.fortiss.af3.mode.simulator.ExecutableMode;
import org.fortiss.af3.project.model.typesystem.ITerm;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.af3.project.services.ITypeSystemService;
import org.fortiss.af3.project.typesystem.IEvaluationContext;
import org.fortiss.af3.project.typesystem.evaluation.Term;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.model.INamedElement;

public class ExecutableModeAutomatonSpecification
extends ExecutableAtomicComponentBase<ModeAutomaton> {
    protected ModeAutomaton modeAutomaton;
    private List<SwitchSegmentSpecification> lastFiredSwitch = new ArrayList<SwitchSegmentSpecification>();
    protected Deque<ArrayList<SwitchSegmentSpecification>> lastFiredSwitchHistory = new LinkedList<ArrayList<SwitchSegmentSpecification>>();
    private final IEvaluationContext scratchPaper;

    public List<SwitchSegmentSpecification> getLastFiredSwitchSegments() {
        return this.lastFiredSwitch;
    }

    public ExecutableModeAutomatonSpecification(ModeAutomaton modeAutomaton, List<ExecutableComponent<?>> subExecutableModes) {
        super((IModelElementSpecification)modeAutomaton, subExecutableModes);
        this.modeAutomaton = modeAutomaton;
        this.scratchPaper = ITypeSystemService.INSTANCE.createEvaluationContext((EObject)this.modelElement);
    }

    public Mode getCurrentMode() {
        return (Mode)this.getInternalValue((EObject)this.modeAutomaton);
    }

    public void setCurrentMode(Mode mode) {
        this.setInternalValue((EObject)this.modeAutomaton, mode);
    }

    public void initialize() {
        IExpressionTerm initialValue;
        for (InputPort ip : this.modelElement.getInputPorts()) {
            if (this.getParentExecutable() != null && (!ip.getIncoming().isEmpty() || this.parentHandlesUnconnected(ip))) continue;
            initialValue = ip.getInitialValue();
            this.setNextInputValue(ip, this.getTermValue((ITerm)initialValue));
        }
        this.setCurrentMode(this.modeAutomaton.getInitialMode());
        for (OutputPort op : this.modelElement.getOutputPorts()) {
            if (this.isWeaklyCausal) continue;
            initialValue = op.getInitialValue();
            this.setCurrentOutputValue(op, (ITerm)initialValue);
        }
        for (ExecutableComponent sub : this.subExecutables) {
            ExecutableMode em = (ExecutableMode)sub;
            em.initialize();
            if (!em.getExecutableMode().equals(this.modeAutomaton.getInitialMode())) continue;
            em.setActive(true);
        }
        for (DataStateVariable dsv : this.modeAutomaton.getDataStateVariables()) {
            initialValue = this.termEvaluator.evaluate((ITerm)dsv.getInitialValue(), this.evaluationContext);
            this.setInternalValue((EObject)dsv, initialValue);
            this.dataStateVariables.put(dsv.getVariable(), dsv);
        }
    }

    public void backupState() {
        super.backupState();
        this.lastFiredSwitchHistory.addLast(new ArrayList<SwitchSegmentSpecification>(this.lastFiredSwitch));
        for (ExecutableComponent sub : this.subExecutables) {
            ExecutableMode em = (ExecutableMode)sub;
            em.backupState();
        }
    }

    public void clearHistory() {
        this.lastFiredSwitchHistory.clear();
        super.clearHistory();
    }

    protected void doPreStep() {
        super.doPreStep();
        for (ExecutableComponent sub : this.subExecutables) {
            ExecutableMode em = (ExecutableMode)sub;
            em.doPreStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAtomicStep() {
        ExecutableModeAutomatonSpecification executableModeAutomatonSpecification = this;
        synchronized (executableModeAutomatonSpecification) {
            for (DataStateVariable dsv : this.modeAutomaton.getDataStateVariables()) {
                this.evaluationContext.setValue((VarBase)dsv.getVariable(), (Term)this.getInternalValue((EObject)dsv));
            }
            this.scratchPaper.clear();
            Mode oldMode = this.getCurrentMode();
            Mode newMode = this.simulateInternal(this.getCurrentMode());
            this.setCurrentMode(newMode);
            if (!newMode.equals(oldMode) && this.getExecutableMode(oldMode) != null) {
                ExecutableMode em = this.getExecutableMode(oldMode);
                em.initialize();
            }
            this.simulateSubComponentOfMode(newMode);
            for (DataStateVariable dsv : this.modeAutomaton.getDataStateVariables()) {
                Term value = this.scratchPaper.getValue((VarBase)dsv.getVariable());
                if (value == null) continue;
                this.setInternalValue((EObject)dsv, value);
            }
        }
    }

    protected void simulateSubComponentOfMode(Mode mode) {
        ExecutableMode em;
        if (this.getExecutableMode(mode) != null && (em = this.getExecutableMode(mode)).getExecutableMode().getModeComponentStructureSpecification() != null) {
            em.doStep();
        }
    }

    protected Mode simulateInternal(Mode startMode) {
        List<List<SwitchSegmentSpecification>> readyToFire = this.computeReadySwitchs(startMode);
        if (readyToFire.isEmpty()) {
            this.lastFiredSwitch.clear();
            return startMode;
        }
        int numReadySwitches = readyToFire.size();
        int i = numReadySwitches == 1 ? 0 : this.chooseNondeterministically(numReadySwitches);
        return this.fireSwitch(startMode, readyToFire.get(i));
    }

    protected int chooseNondeterministically(int numChoices) {
        return (int)(Math.random() * (double)numChoices);
    }

    protected List<List<SwitchSegmentSpecification>> computeReadySwitchs(Mode start) {
        LinkedList<List<SwitchSegmentSpecification>> retColl = new LinkedList<List<SwitchSegmentSpecification>>();
        ArrayList<SwitchSegmentSpecification> singlePath = new ArrayList<SwitchSegmentSpecification>();
        for (SwitchSegmentExitConnector exit : start.getSwitchSegmentExitConnectors()) {
            if (exit.getOutgoing().isEmpty()) continue;
            this.findSegmentPath(exit, retColl, singlePath);
            singlePath.clear();
        }
        return retColl;
    }

    protected void findSegmentPath(SwitchSegmentConnector tp, List<List<SwitchSegmentSpecification>> pathList, List<SwitchSegmentSpecification> currentPath) {
        for (SwitchSegmentSpecification sseg : currentPath) {
            if (sseg.getSwitchSegment().getSource() != tp) continue;
            throw new ExecutionException("Found cycle connector point " + tp.getName() + " in mode " + tp.getMode().getName());
        }
        if (tp.getOutgoing().isEmpty() && !tp.getMode().getSubModes().isEmpty()) {
            throw new ExecutionException("Found terminating connector point " + tp.getName() + " in mode " + ((INamedElement)tp.eContainer()).getName() + ", but target mode " + tp.getMode().getName() + " is not atomic.");
        }
        if (tp.getOutgoing().isEmpty()) {
            pathList.add(currentPath);
            return;
        }
        for (SwitchSegment ts : tp.getOutgoingSwitchSegment()) {
            SwitchSegmentSpecification spec = this.canFireSwitchSegment(ts);
            if (spec == null) continue;
            ArrayList<SwitchSegmentSpecification> nextPath = new ArrayList<SwitchSegmentSpecification>(currentPath.size() + 1);
            nextPath.addAll(currentPath);
            nextPath.add(spec);
            this.findSegmentPath(ts.getTargetConnector(), pathList, nextPath);
        }
    }

    protected SwitchSegmentSpecification canFireSwitchSegment(SwitchSegment ts) {
        SwitchSegmentSpecification spec = ts.getSwitchSegmentSpecification();
        Guard guard = spec.getGuard();
        if (guard == null) {
            return spec;
        }
        Term result = this.termEvaluator.evaluate((ITerm)guard.getExpression(), this.evaluationContext);
        if (result instanceof BoolValue) {
            if (result.equals(BoolValue.FALSE)) {
                return null;
            }
        } else {
            throw new ExecutionException(guard.getExpression().toString() + " evaluated to " + result.toString() + "; expected boolean value!");
        }
        return spec;
    }

    protected Mode fireSwitch(Mode currentMode, List<SwitchSegmentSpecification> switchSpecifications) {
        this.lastFiredSwitch = switchSpecifications;
        if (switchSpecifications == null) {
            return currentMode;
        }
        return switchSpecifications.get(switchSpecifications.size() - 1).getSwitchSegment().getTargetConnector().getMode();
    }

    public List<ExecutableComponent<?>> getSubElements() {
        return this.subExecutables;
    }

    protected ExecutableMode getExecutableMode(Mode mode) {
        for (ExecutableComponent sub : this.subExecutables) {
            ExecutableMode em = (ExecutableMode)sub;
            if (!em.getExecutableMode().equals(mode)) continue;
            return em;
        }
        return null;
    }

    public List<DataStateVariable> getVariables() {
        return this.modeAutomaton.getDataStateVariables();
    }

    public Term<? extends ITerm> getCurrentVariableValue(DataStateVariable dsv) {
        return (Term)this.getInternalValue((EObject)dsv);
    }

    public void setVariableValue(DataStateVariable dsv, Object value) {
        this.setInternalValue((EObject)dsv, value);
    }

    public SignalSource findOutputPortSignalSource(OutputPort outputPort) {
        ExecutableMode execMode = this.getExecutableMode(this.getCurrentMode());
        OutputPort out = execMode.getModelElement().findOutputPort(outputPort.getName());
        return execMode.findOutputPortSignalSource(out);
    }

    public Term<? extends ITerm> getInternalOutputValue(OutputPort port) {
        SignalSource source = this.findOutputPortSignalSource(port);
        return source.getExecutable().getCurrentValue(source.getPort());
    }

    public void restoreState() {
        for (ExecutableComponent sub : this.subExecutables) {
            ExecutableMode em = (ExecutableMode)sub;
            em.restoreState();
        }
        this.lastFiredSwitch = this.lastFiredSwitchHistory.removeLast();
        super.restoreState();
    }
}

