/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.simulator.transform;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.simulator.ExecutableComponent;
import org.fortiss.af3.component.simulator.transform.ExecutableComponentTransformationBase;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.simulator.ExecutableModeAutomatonSpecification;
import org.fortiss.af3.mode.simulator.transform.MissingModeComponentStructureTranformation;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.extension.ITransformationProvider;
import org.fortiss.tooling.kernel.extension.data.ITransformationContext;
import org.fortiss.tooling.kernel.extension.exception.ChainTransformationFailedException;
import org.fortiss.tooling.kernel.extension.exception.TransformationFailedException;
import org.fortiss.tooling.kernel.utils.TransformationUtils;

public class ExecutableModeSpecificationTransformation
extends ExecutableComponentTransformationBase {
    public boolean canHandleChainTransformation(Class<?> sourceClass, ITransformationContext context) {
        return ModeAutomaton.class.isAssignableFrom(sourceClass);
    }

    public boolean canTransform(Object source, ITransformationContext context) {
        return source instanceof ModeAutomaton && ((ModeAutomaton)source).eContainer() instanceof Component;
    }

    public Object transform(Object source, ITransformationContext context) throws TransformationFailedException {
        Mode root = ((ModeAutomaton)source).getRootMode();
        ArrayList subExecutables = new ArrayList();
        for (IHierarchicElement subMode : root.getContainedElements()) {
            ExecutableComponent<? extends IModelElementSpecification> subExecutableMode = this.createExecutableForMode((Mode)subMode, context);
            if (subExecutableMode != null) {
                subExecutables.add(subExecutableMode);
                continue;
            }
            throw new MissingModeComponentStructureTranformation((ITransformationProvider)this, subExecutables);
        }
        return new ExecutableModeAutomatonSpecification((ModeAutomaton)source, subExecutables);
    }

    protected ExecutableComponent<? extends IModelElementSpecification> createExecutableForMode(Mode mode, ITransformationContext context) throws TransformationFailedException {
        ChainTransformationFailedException lastException = null;
        try {
            ExecutableComponent exec = (ExecutableComponent)TransformationUtils.createTransformedObjectFor((EObject)mode, (Class)this.getTargetClass(), (ITransformationContext)context);
            if (exec != null) {
                return exec;
            }
        }
        catch (ChainTransformationFailedException cex) {
            lastException = cex;
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }
}

