/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.expression.language.Compiler;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.model.impl.ModeImpl;
import org.fortiss.af3.project.model.typesystem.IVariableDefinition;
import org.fortiss.af3.project.model.typesystem.VarBase;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class ModeAutomatonUtils {
    private static Compiler compiler = new Compiler();

    public static Mode getInitialMode(ModeAutomaton automaton) {
        if (automaton != null && automaton.getRootMode() != null) {
            for (Mode mode : automaton.getRootMode().getSubModes()) {
                if (!mode.isInitial()) continue;
                return mode;
            }
        }
        return null;
    }

    public static ModeAutomaton getModeAutomaton(Mode mode) {
        Mode tmp = mode;
        while (tmp.eContainer() instanceof Mode) {
            tmp = (Mode)tmp.eContainer();
        }
        return tmp.eContainer() instanceof ModeAutomaton ? (ModeAutomaton)tmp.eContainer() : null;
    }

    public static Component getTopComponent(Mode mode) {
        return (Component)KernelModelElementUtils.getParentElement((EObject)mode, Component.class, (boolean)false);
    }

    public static DataStateVariable findVariableByName(ModeAutomaton automaton, String name) {
        for (DataStateVariable dsv : automaton.getDataStateVariables()) {
            if (!dsv.getIdentifier().equals(name)) continue;
            return dsv;
        }
        return null;
    }

    public static Component getSuperComponent(Mode mode) {
        if (mode.getClass() == ModeImpl.class) {
            return ModeAutomatonUtils.getModeAutomaton(mode).getContainerComponent();
        }
        return ModeAutomatonUtils.getTopComponent(mode);
    }

    public static IVariableDefinition getDefinitionElement(ModeAutomaton modeAutomaton, VarBase var) {
        return ModeAutomatonUtils.findVariableByName(modeAutomaton, var.getIdentifier());
    }

    public static ModeAutomaton getModeAutomaton(Component component) {
        return (ModeAutomaton)EcoreUtils.pickFirstInstanceOf(ModeAutomaton.class, (List)component.getSpecifications());
    }

    private static void setGuard(SwitchSegment switchSegment, Guard guard) {
        switchSegment.getSwitchSegmentSpecification().setGuard(guard);
    }

    private static void setGuard(SwitchSegment switchSegment, IExpressionTerm guardExpression) {
        ModeAutomatonUtils.setGuard(switchSegment, BehaviorModelElementFactory.createGuard((IExpressionTerm)guardExpression));
    }

    public static void setGuard(SwitchSegment switchSegment, String guard) {
        ModeAutomatonUtils.setGuard(switchSegment, compiler.compileTerm(guard, (EObject)switchSegment));
    }

    public static ModeAutomaton getEnclosingModeAutomaton(EObject element) {
        return (ModeAutomaton)KernelModelElementUtils.getParentElement((EObject)element, ModeAutomaton.class, (boolean)true);
    }

    public static Mode getEnclosingMode(EObject element) {
        return (Mode)KernelModelElementUtils.getParentElement((EObject)element, Mode.class, (boolean)true);
    }

    public static List<SwitchSegment> findSwitchSegmentWithGuard(Mode mode) {
        if (mode.getOutgoingSwitchSegments() == null) {
            return null;
        }
        ArrayList<SwitchSegment> result = new ArrayList<SwitchSegment>();
        for (SwitchSegment ss : mode.getOutgoingSwitchSegments()) {
            if (ss.getSwitchSegmentSpecification().getGuard() == null) continue;
            result.add(ss);
        }
        return result;
    }
}

