/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mode.utils;

import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.behavior.common.DataStateVariable;
import org.fortiss.af3.component.model.behavior.common.Guard;
import org.fortiss.af3.component.utils.BehaviorModelElementFactory;
import org.fortiss.af3.component.utils.ComponentModelElementFactory;
import org.fortiss.af3.expression.model.terms.IExpressionTerm;
import org.fortiss.af3.mode.model.AF3ModeFactory;
import org.fortiss.af3.mode.model.Mode;
import org.fortiss.af3.mode.model.ModeAutomaton;
import org.fortiss.af3.mode.model.ModeComponentStructureSpecification;
import org.fortiss.af3.mode.model.ModeSpecification;
import org.fortiss.af3.mode.model.SwitchSegment;
import org.fortiss.af3.mode.model.SwitchSegmentEntryConnector;
import org.fortiss.af3.mode.model.SwitchSegmentExitConnector;
import org.fortiss.af3.mode.model.SwitchSegmentSpecification;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public class ModeModelElementFactory {
    public static ModeAutomaton createModeAutomaton() {
        return ModeModelElementFactory.createModeAutomaton("RootMode");
    }

    public static ModeAutomaton createModeAutomaton(String rootModeName) {
        ModeAutomaton automaton = AF3ModeFactory.eINSTANCE.createModeAutomaton();
        Mode rootMode = ModeModelElementFactory.createMode(rootModeName, "", false);
        automaton.getContainedElements().add((Object)rootMode);
        return automaton;
    }

    public static ModeAutomaton createModeAutomaton(Component component) {
        ModeAutomaton modeAutomaton = ModeModelElementFactory.createModeAutomaton();
        component.getSpecifications().add((Object)modeAutomaton);
        return modeAutomaton;
    }

    public static Mode createMode() {
        return ModeModelElementFactory.createMode("Mode", "", false);
    }

    public static Mode createMode(String name, String comment, boolean isInitial) {
        Mode mode = AF3ModeFactory.eINSTANCE.createMode();
        mode.setName(name);
        mode.setComment(comment);
        LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)mode);
        ModeSpecification modesSpec = AF3ModeFactory.eINSTANCE.createModeSpecification();
        modesSpec.setInitial(isInitial);
        mode.getSpecifications().add((Object)modesSpec);
        return mode;
    }

    public static Mode createMode(Mode parent, String name, String comment, boolean isInitial) {
        Mode sub = ModeModelElementFactory.createMode(name, comment, isInitial);
        parent.getContainedElements().add((Object)sub);
        return sub;
    }

    public static SwitchSegmentEntryConnector createSwitchSegmentEntryConnector(String name, String comment) {
        SwitchSegmentEntryConnector connector = AF3ModeFactory.eINSTANCE.createSwitchSegmentEntryConnector();
        connector.setName(name);
        connector.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)connector);
        return connector;
    }

    public static SwitchSegmentExitConnector createSwitchSegmentExitConnector(String name, String comment) {
        SwitchSegmentExitConnector connector = AF3ModeFactory.eINSTANCE.createSwitchSegmentExitConnector();
        connector.setName(name);
        connector.setComment(comment);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)connector);
        return connector;
    }

    public static SwitchSegment createSwitchSegment() {
        return ModeModelElementFactory.createSwitchSegment("Switch Segment", "");
    }

    public static SwitchSegment createSwitchSegment(String name, String comment) {
        SwitchSegment switchSegment = AF3ModeFactory.eINSTANCE.createSwitchSegment();
        switchSegment.setName(name);
        switchSegment.setComment(comment);
        SwitchSegmentSpecification switchSegmentSpec = AF3ModeFactory.eINSTANCE.createSwitchSegmentSpecification();
        switchSegment.getSpecifications().add((Object)switchSegmentSpec);
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)switchSegment);
        return switchSegment;
    }

    public static SwitchSegment createSwitchSegment(Mode parent, Mode source, Mode target, String name, String comment) {
        SwitchSegment segment = ModeModelElementFactory.createSwitchSegment(name, comment);
        parent.getConnections().add((Object)segment);
        SwitchSegmentExitConnector sourcePoint = ModeModelElementFactory.createSwitchSegmentExitConnector("Source", "");
        source.getConnectors().add((Object)sourcePoint);
        SwitchSegmentEntryConnector targetPoint = ModeModelElementFactory.createSwitchSegmentEntryConnector("Target", "");
        target.getConnectors().add((Object)targetPoint);
        segment.setSource((IConnector)sourcePoint);
        segment.setTarget((IConnector)targetPoint);
        return segment;
    }

    public static Guard createGuard(SwitchSegment parent, IExpressionTerm guardTerm) {
        Guard guard = BehaviorModelElementFactory.createGuard((IExpressionTerm)guardTerm);
        parent.getSwitchSegmentSpecification().setGuard(guard);
        return guard;
    }

    public static DataStateVariable createDataStateVariable(ModeAutomaton parent, String name, IType type, IExpressionTerm initVal) {
        DataStateVariable dsvar = BehaviorModelElementFactory.createDataStateVariable((String)name, (IType)type, (IExpressionTerm)initVal);
        parent.getDataStateVariables().add((Object)dsvar);
        return dsvar;
    }

    public static ModeComponentStructureSpecification createModeCompStruSpec(String topComponentName, String comment) {
        ModeComponentStructureSpecification modeCompSpec = AF3ModeFactory.eINSTANCE.createModeComponentStructureSpecification();
        Component component = ComponentModelElementFactory.createComponent((String)topComponentName, (String)comment);
        modeCompSpec.getContainedElements().add((Object)component);
        return modeCompSpec;
    }

    public static ModeComponentStructureSpecification createModeCompStruSpec(Component topComponent) {
        ModeComponentStructureSpecification modeCompSpec = AF3ModeFactory.eINSTANCE.createModeComponentStructureSpecification();
        modeCompSpec.getContainedElements().add((Object)topComponent);
        return modeCompSpec;
    }
}

