/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.action;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.utils.HighlightUtils;
import org.fortiss.af3.mira.utils.MiraModelElementFactory;
import org.fortiss.tooling.kernel.service.ICommandStackService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.ui.extension.base.EObjectActionBase;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;

public class CreateGlossaryEntryAction
extends EObjectActionBase<Analysis> {
    private final String name;
    private final Shell shell;

    public CreateGlossaryEntryAction(Analysis analysis, String name, Shell shell) {
        super((EObject)analysis, "Create new glossary entry");
        this.name = name;
        this.shell = shell;
    }

    public void run() {
        final Analysis analysis = (Analysis)this.getTarget();
        Glossary glossary = null;
        if (analysis.getGlossariesList().size() == 0) {
            ICommandStackService.getInstance().runAsCommand(this.getTarget(), new Runnable(){

                @Override
                public void run() {
                    Glossary newGlossary = MiraModelElementFactory.createGlossary((String)"Glossary", (String)"");
                    IPersistencyService.getInstance().getTopLevelElementFor((EObject)analysis).prepareIDs((EObject)newGlossary);
                    analysis.getContainedElements().add((Object)newGlossary);
                }
            });
        }
        if (analysis.getGlossariesList().size() == 1) {
            glossary = (Glossary)analysis.getGlossariesList().get(0);
        } else if (analysis.getGlossariesList().size() > 1) {
            glossary = HighlightUtils.openGlossaryDialog(this.shell, analysis, (EObject)analysis.getGlossariesList().get(0));
        }
        if (glossary != null) {
            GlossaryEntry entry = MiraModelElementFactory.createGlossaryEntry((String)this.name, (String)"", (String)"");
            IPersistencyService.getInstance().getTopLevelElementFor((EObject)analysis).prepareIDs((EObject)entry);
            ICommandStackService.getInstance().runAsCommand((EObject)glossary, (Runnable)new addToGlossaryAction(glossary, entry));
            IModelEditorBindingService.getInstance().openInEditor((EObject)entry);
        }
    }

    private class addToGlossaryAction
    implements Runnable {
        Glossary glossary;
        GlossaryEntry entry;

        public addToGlossaryAction(Glossary glossary, GlossaryEntry entry) {
            this.glossary = glossary;
            this.entry = entry;
        }

        @Override
        public void run() {
            this.glossary.getContainedElements().add((Object)this.entry);
        }
    }
}

