/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.mira.ui.dialog.ElementTreeDoubleMultiSelectDialogGUI;
import org.fortiss.af3.mira.ui.dialog.ElementTreeMultiSelectDialog;
import org.fortiss.tooling.base.ui.dialog.MultiRootTreeContentProvider;
import org.fortiss.tooling.kernel.ui.dnd.CompositionServiceLocalDNDTransfer;

public class ElementTreeDoubleMultiSelectDialog
extends ElementTreeMultiSelectDialog<ElementTreeDoubleMultiSelectDialogGUI> {
    private ArrayList<Object> selectedElements2;
    private static final Point initialSize = new Point(900, 600);

    public ElementTreeDoubleMultiSelectDialog(Shell parentShell, List<?> roots, List<?> selected, List<?> selected2, ITreeContentProvider contentProvider, ILabelProvider labelProvider, String title, String message) {
        super(parentShell, roots, selected, contentProvider, labelProvider, title, message);
        this.selectedElements2 = selected2 == null ? new ArrayList() : new ArrayList(selected2);
    }

    @Override
    protected boolean isSelected(Object element) {
        return this.selectedElements.contains(element) || this.selectedElements2.contains(element);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite area = (Composite)super.createDialogArea(parent);
        this.gui = new ElementTreeDoubleMultiSelectDialogGUI(area, 0);
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().addDragSupport(1, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = ((ElementTreeDoubleMultiSelectDialogGUI)ElementTreeDoubleMultiSelectDialog.this.gui).getElementTreeViewer().getSelection();
                if (event.data == null) {
                    return;
                }
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().setLabelProvider((IBaseLabelProvider)new ElementTreeMultiSelectDialog.DecorateLabelProvider(this));
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().getTree().setHeaderVisible(true);
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider((List)this.rootElements, this.contentSupport));
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().setInput((Object)this.rootElements);
        this.createTreeViewer1();
        this.createTreeViewer2();
        this.setDefaultSelection();
        return area;
    }

    private void createTreeViewer1() {
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeDoubleMultiSelectDialog.this.deselectElement();
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().addDragSupport(2, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = ((ElementTreeDoubleMultiSelectDialogGUI)ElementTreeDoubleMultiSelectDialog.this.gui).getSelectTreeViewer().getSelection();
                if (event.data == null) {
                    return;
                }
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().addDropSupport(3, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                if (ElementTreeDoubleMultiSelectDialog.this.validateDrop(event.currentDataType)) {
                    event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : 0);
                }
            }

            public void drop(DropTargetEvent event) {
                if (ElementTreeDoubleMultiSelectDialog.this.validateDrop(event.currentDataType)) {
                    Control target = ((DropTarget)event.getSource()).getControl();
                    Control selectTree1 = ((ElementTreeDoubleMultiSelectDialogGUI)ElementTreeDoubleMultiSelectDialog.this.gui).getSelectTreeViewer().getControl();
                    ElementTreeDoubleMultiSelectDialog.this.dropAtSelect((ITreeSelection)event.data, event.detail, target.equals(selectTree1));
                }
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().setLabelProvider((IBaseLabelProvider)new ElementTreeMultiSelectDialog.DecorateLabelProvider(this));
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().getTree().setHeaderVisible(true);
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider((List)this.selectedElements, (ITreeContentProvider)new ElementTreeMultiSelectDialog.EmptyTreeContentProvider()));
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().setInput((Object)this.selectedElements);
    }

    private void createTreeViewer2() {
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeDoubleMultiSelectDialog.this.deselectElement2();
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().addDragSupport(2, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = ((ElementTreeDoubleMultiSelectDialogGUI)ElementTreeDoubleMultiSelectDialog.this.gui).getSelectTreeViewer2().getSelection();
                if (event.data == null) {
                    return;
                }
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().addDropSupport(3, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                if (ElementTreeDoubleMultiSelectDialog.this.validateDrop(event.currentDataType)) {
                    event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : 0);
                }
            }

            public void drop(DropTargetEvent event) {
                if (ElementTreeDoubleMultiSelectDialog.this.validateDrop(event.currentDataType)) {
                    Control target = ((DropTarget)event.getSource()).getControl();
                    Control selectTree1 = ((ElementTreeDoubleMultiSelectDialogGUI)ElementTreeDoubleMultiSelectDialog.this.gui).getSelectTreeViewer().getControl();
                    ElementTreeDoubleMultiSelectDialog.this.dropAtSelect((ITreeSelection)event.data, event.detail, target.equals(selectTree1));
                }
            }
        });
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().setLabelProvider((IBaseLabelProvider)new ElementTreeMultiSelectDialog.DecorateLabelProvider(this));
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().getTree().setHeaderVisible(true);
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().setContentProvider((IContentProvider)new MultiRootTreeContentProvider(this.selectedElements2, (ITreeContentProvider)new ElementTreeMultiSelectDialog.EmptyTreeContentProvider()));
        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().setInput(this.selectedElements2);
    }

    @Override
    protected Point getInitialSize() {
        return initialSize;
    }

    public List<Object> getMultiSelectedElements2() {
        return this.selectedElements2;
    }

    protected void dropAtSelect(ITreeSelection selection, int type, boolean dropAtTree1) {
        try {
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (!(type == 1 && this.isSelected(path.getLastSegment()) || dropAtTree1 && this.selectedElements.contains(path.getLastSegment()) || !dropAtTree1 && this.selectedElements2.contains(path.getLastSegment()) || !this.acceptElement(path.getLastSegment()))) {
                    if (dropAtTree1) {
                        this.selectAction(path.getLastSegment());
                        this.selectedElements.add(path.getLastSegment());
                        if (type == 2) {
                            this.selectedElements2.remove(path.getLastSegment());
                            ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().remove(path.getLastSegment());
                        }
                        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().add((Object)this.selectedElements, path.getLastSegment());
                    } else {
                        this.selectAction2(path.getLastSegment());
                        this.selectedElements2.add(path.getLastSegment());
                        if (type == 2) {
                            this.selectedElements.remove(path.getLastSegment());
                            ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer().remove(path.getLastSegment());
                        }
                        ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().add(this.selectedElements2, path.getLastSegment());
                    }
                    ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().update(path.getLastSegment(), null);
                    ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).layout();
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void deselectElement2() {
        ITreeSelection selection = (ITreeSelection)((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().getSelection();
        if (selection.getPaths() == null) {
            return;
        }
        TreePath[] treePathArray = selection.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            if (this.canDeselect2(path.getLastSegment())) {
                this.deselectAction2(path.getLastSegment());
                if (this.selectedElements2.remove(path.getLastSegment())) {
                    ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getSelectTreeViewer2().remove(path.getLastSegment());
                    ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).getElementTreeViewer().update(path.getLastSegment(), null);
                    ((ElementTreeDoubleMultiSelectDialogGUI)this.gui).layout();
                }
            }
            ++n2;
        }
    }

    protected boolean selectAction2(Object selectedElement) {
        return false;
    }

    protected boolean deselectAction2(Object deselectedElement) {
        return false;
    }

    public boolean canDeselect2(Object toDeselectedElement) {
        return true;
    }

    @Override
    protected ElementTreeDoubleMultiSelectDialogGUI getGUI() {
        return new ElementTreeDoubleMultiSelectDialogGUI(this.area, 0);
    }
}

