/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import org.conqat.ide.commons.ui.jface.TreeContentProviderBase;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.fortiss.af3.mira.ui.dialog.ElementTreeMultiSelectDialogGUI;
import org.fortiss.tooling.kernel.ui.dnd.CompositionServiceLocalDNDTransfer;

public abstract class ElementTreeMultiSelectDialog<T extends ElementTreeMultiSelectDialogGUI>
extends TitleAreaDialog {
    protected ArrayList<Object> rootElements;
    protected ArrayList<Object> selectedElements;
    protected ITreeContentProvider contentSupport;
    protected ILabelProvider labelSupport;
    protected TreePath selectedPath;
    protected Composite area;
    protected T gui;
    protected String title;
    protected String message;

    public ElementTreeMultiSelectDialog(Shell parentShell, List<?> roots, List<?> selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider, String title, String message) {
        super(parentShell);
        this.rootElements = roots == null ? new ArrayList() : new ArrayList(roots);
        this.selectedElements = selected == null ? new ArrayList() : new ArrayList(selected);
        this.title = title;
        this.message = message;
        this.contentSupport = contentProvider;
        this.labelSupport = labelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    public boolean hasConnectedSelectedElement(Object element) {
        return this.isSelected(element);
    }

    protected abstract T getGUI();

    protected boolean validateDrop(TransferData type) {
        return CompositionServiceLocalDNDTransfer.getInstance().isSupportedType(type);
    }

    protected void dropAtSelect(ITreeSelection selection, int type) {
        try {
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object convertedSelection;
                TreePath path = treePathArray[n2];
                if (!(type == 1 && this.isSelected(path.getLastSegment()) || (convertedSelection = this.selectConverterAction(path.getLastSegment())) == null || this.selectedElements.contains(convertedSelection) || !this.acceptElement(path.getLastSegment()))) {
                    this.selectAction(path.getLastSegment());
                    this.selectedElements.add(convertedSelection);
                    if (type == 2) {
                        this.selectedElements.remove(convertedSelection);
                        ((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getSelectTreeViewer().remove(convertedSelection);
                    }
                    ((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getSelectTreeViewer().add(this.selectedElements, convertedSelection);
                    ((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getElementTreeViewer().update(path.getLastSegment(), null);
                    this.gui.layout();
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void setDefaultSelection() {
        ArrayList<Object> path = new ArrayList<Object>();
        if (this.rootElements.size() <= 0) {
            return;
        }
        Object child = this.rootElements.get(0);
        path.add(child);
        while (this.contentSupport.getChildren(child).length > 0) {
            if ((child = this.contentSupport.getChildren(child)[0]) == null) {
                return;
            }
            path.add(child);
        }
        TreePath newTreepath = new TreePath(path.toArray());
        ((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getElementTreeViewer().setSelection((ISelection)new TreeSelection(newTreepath), true);
        this.gui.layout();
    }

    protected void deselectElement() {
        try {
            ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getSelectTreeViewer().getSelection();
            if (selection.getPaths() == null) {
                return;
            }
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (this.canDeselect(path.getLastSegment())) {
                    this.deselectAction(path.getLastSegment());
                    if (this.selectedElements.remove(path.getLastSegment())) {
                        ((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getSelectTreeViewer().remove(path.getLastSegment());
                        ((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getElementTreeViewer().refresh();
                    }
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    protected void checkSelectionSelectTree() {
        ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectDialogGUI)((Object)this.gui)).getSelectTreeViewer().getSelection();
        if (selection.getPaths() != null && selection.getPaths().length == 1 && this.acceptElement(selection.getPaths()[0].getLastSegment())) {
            this.selectedPath = selection.getPaths()[0];
        }
    }

    protected boolean isSelected(Object element) {
        return this.selectedElements.contains(element);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    protected abstract Point getInitialSize();

    public String getTitle() {
        return this.title;
    }

    public List<Object> getRootElements() {
        return this.rootElements;
    }

    public List<Object> getMultiSelectedElements() {
        return this.selectedElements;
    }

    public Object getSingleSelectedElement() {
        if (this.selectedPath == null) {
            return null;
        }
        return this.selectedPath.getLastSegment();
    }

    public IStructuredContentProvider getContentProvider() {
        return this.contentSupport;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelSupport;
    }

    public boolean acceptElement(Object element) {
        return true;
    }

    public Object selectConverterAction(Object selectedElement) {
        return selectedElement;
    }

    public boolean selectAction(Object selectedElement) {
        return false;
    }

    public boolean deselectAction(Object deselectedElement) {
        return false;
    }

    public boolean canSelect(Object toSelectedElement) {
        return true;
    }

    public boolean canDeselect(Object toDeselectedElement) {
        return true;
    }

    protected class DecorateLabelProvider
    extends LabelProvider {
        protected DecorateLabelProvider() {
        }

        public String getText(Object element) {
            return ElementTreeMultiSelectDialog.this.labelSupport.getText(element);
        }

        public Image getImage(Object element) {
            Image image = ElementTreeMultiSelectDialog.this.labelSupport.getImage(element);
            if (!ElementTreeMultiSelectDialog.this.hasConnectedSelectedElement(element)) {
                return image;
            }
            Image icon = ResourceManager.getPluginImage((String)"org.eclipse.ui", (String)"/icons/full/ovr16/pinned_ovr.gif");
            if (icon == null) {
                return image;
            }
            return ResourceManager.decorateImage((Image)image, (Image)icon, (int)4);
        }
    }

    protected static class EmptyTreeContentProvider
    extends TreeContentProviderBase {
        protected EmptyTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }
    }
}

