/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.dialog;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.fortiss.af3.mira.ui.dialog.ElementTreeMultiSelectDialog;
import org.fortiss.af3.mira.ui.dialog.ElementTreeMultiSelectEditableDialogGUI;
import org.fortiss.tooling.base.ui.dialog.IDialogEditSupport;
import org.fortiss.tooling.base.ui.dialog.MultiRootTreeContentProvider;
import org.fortiss.tooling.kernel.ui.dnd.CompositionServiceLocalDNDTransfer;

public class ElementTreeMultiSelectEditableDialog
extends ElementTreeMultiSelectDialog<ElementTreeMultiSelectEditableDialogGUI> {
    private IDialogEditSupport dialogEditSupport;

    public ElementTreeMultiSelectEditableDialog(Shell parentShell, List<?> roots, List<?> selected, ITreeContentProvider contentProvider, ILabelProvider labelProvider, IDialogEditSupport edit, String title, String message) {
        super(parentShell, roots, selected, contentProvider, labelProvider, title, message);
        this.dialogEditSupport = edit;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setHelpAvailable(false);
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite area = (Composite)super.createDialogArea(parent);
        this.gui = new ElementTreeMultiSelectEditableDialogGUI(area, 0);
        if (this.dialogEditSupport == null) {
            ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getEditToolBar().setVisible(false);
            ((GridData)((ElementTreeMultiSelectEditableDialogGUI)this.gui).getEditToolBar().getLayoutData()).exclude = true;
        }
        this.createButtonListeners();
        this.createElementTreeViewer();
        this.createSelectTreeViewer();
        this.setDefaultSelection();
        return area;
    }

    private void createButtonListeners() {
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getCreateButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeMultiSelectEditableDialog.this.createElement();
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeMultiSelectEditableDialog.this.deleteElement();
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeMultiSelectEditableDialog.this.editElement();
            }
        });
    }

    private void createElementTreeViewer() {
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeMultiSelectEditableDialog.this.selectElement();
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementTreeMultiSelectEditableDialog.this.checkSelectionElementTree();
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().addDragSupport(1, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = ((ElementTreeMultiSelectEditableDialogGUI)ElementTreeMultiSelectEditableDialog.this.gui).getElementTreeViewer().getSelection();
                if (event.data == null) {
                    return;
                }
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().setLabelProvider((IBaseLabelProvider)new ElementTreeMultiSelectDialog.DecorateLabelProvider());
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider((List)this.rootElements, this.contentSupport));
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().setInput((Object)this.rootElements);
    }

    private void createSelectTreeViewer() {
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().addDragSupport(2, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                event.data = ((ElementTreeMultiSelectEditableDialogGUI)ElementTreeMultiSelectEditableDialog.this.gui).getSelectTreeViewer().getSelection();
                if (event.data == null) {
                    return;
                }
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().addDropSupport(3, new Transfer[]{CompositionServiceLocalDNDTransfer.getInstance()}, (DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
                if (ElementTreeMultiSelectEditableDialog.this.validateDrop(event.currentDataType)) {
                    event.detail = (event.operations & 1) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : 0);
                }
            }

            public void drop(DropTargetEvent event) {
                if (ElementTreeMultiSelectEditableDialog.this.validateDrop(event.currentDataType)) {
                    ElementTreeMultiSelectEditableDialog.this.dropAtSelect((ITreeSelection)event.data, event.detail);
                }
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ElementTreeMultiSelectEditableDialog.this.deselectElement();
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementTreeMultiSelectEditableDialog.this.checkSelectionSelectTree();
            }
        });
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().setLabelProvider((IBaseLabelProvider)new ElementTreeMultiSelectDialog.DecorateLabelProvider());
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().setContentProvider((IContentProvider)new MultiRootTreeContentProvider((List)this.selectedElements, (ITreeContentProvider)new ElementTreeMultiSelectDialog.EmptyTreeContentProvider()));
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().setInput((Object)this.selectedElements);
    }

    private void checkSelectionElementTree() {
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getCreateButton().setEnabled(true);
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getDeleteButton().setEnabled(true);
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getEditButton().setEnabled(true);
    }

    @Override
    protected void checkSelectionSelectTree() {
        ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().getSelection();
        if (selection.getPaths() != null && selection.getPaths().length == 1 && this.acceptElement(selection.getPaths()[0].getLastSegment())) {
            this.selectedPath = selection.getPaths()[0];
        }
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getCreateButton().setEnabled(false);
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getDeleteButton().setEnabled(false);
        ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getEditButton().setEnabled(false);
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(640, 640);
    }

    public IDialogEditSupport getEditSupport() {
        return this.dialogEditSupport;
    }

    private void selectElement() {
        try {
            ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().getSelection();
            if (selection.getPaths() == null) {
                return;
            }
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object convertedSelection;
                TreePath path = treePathArray[n2];
                if (this.canSelect(path.getLastSegment()) && (convertedSelection = this.selectConverterAction(path.getLastSegment())) != null && !this.selectedElements.contains(convertedSelection) && this.acceptElement(path.getLastSegment())) {
                    this.selectAction(path.getLastSegment());
                    this.selectedElements.add(convertedSelection);
                    ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().add((Object)this.selectedElements, convertedSelection);
                    ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().update(path.getLastSegment(), null);
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void createElement() {
        if (this.dialogEditSupport == null) {
            return;
        }
        try {
            TreePath path;
            ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().getSelection();
            if (selection.getPaths() == null || selection.getPaths().length != 1) {
                return;
            }
            Object o = selection.getPaths() == null ? this.dialogEditSupport.createElement(null) : this.dialogEditSupport.createElement(selection.getPaths()[0].getLastSegment());
            if (o == null) {
                return;
            }
            if (selection.getPaths() == null) {
                path = new TreePath(new Object[]{this.rootElements});
                this.rootElements.add(o);
            } else {
                path = selection.getPaths()[0];
            }
            ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().add((Object)path, o);
            ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().reveal(o);
            ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().refresh();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void deleteElement() {
        if (this.dialogEditSupport == null) {
            return;
        }
        try {
            ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().getSelection();
            if (selection.getPaths() == null) {
                return;
            }
            TreePath[] treePathArray = selection.getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                if (this.dialogEditSupport.deleteElement(path.getLastSegment())) {
                    if (this.rootElements.contains(path.getLastSegment())) {
                        this.rootElements.remove(path.getLastSegment());
                    }
                    if (this.selectedElements.contains(path.getLastSegment())) {
                        this.selectedElements.remove(path.getLastSegment());
                    }
                    ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().remove((Object)path);
                    ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().remove((Object)path);
                    ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().refresh();
                    ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().refresh();
                }
                ++n2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void editElement() {
        if (this.dialogEditSupport == null) {
            return;
        }
        try {
            ITreeSelection selection = (ITreeSelection)((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().getSelection();
            if (selection.getPaths() == null || selection.getPaths().length != 1) {
                return;
            }
            TreePath path = selection.getPaths()[0];
            this.dialogEditSupport.editElement(path.getLastSegment());
            ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getElementTreeViewer().refresh();
            ((ElementTreeMultiSelectEditableDialogGUI)this.gui).getSelectTreeViewer().refresh();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    protected ElementTreeMultiSelectEditableDialogGUI getGUI() {
        return new ElementTreeMultiSelectEditableDialogGUI(this.area, 0);
    }
}

