/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor;

import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.mira.model.Requirement;
import org.fortiss.af3.mira.model.RequirementPriority;
import org.fortiss.tooling.common.ui.javafx.layout.CompositeFXControllerBase;
import org.fortiss.tooling.common.ui.javafx.layout.ICompositeFXController;
import org.fortiss.tooling.kernel.service.ICommandStackService;

public class RequirementController
extends CompositeFXControllerBase<VBox, Node> {
    Requirement editedReq;
    @FXML
    TextField txtId;
    @FXML
    TextField txtTitle;
    @FXML
    TextField txtAuthor;
    @FXML
    TextField txtSource;
    @FXML
    TextArea txaDescription;
    @FXML
    TextArea txaRationale;
    @FXML
    Spinner<RequirementPriority> spnPriority;

    public RequirementController(Requirement editedRequirement) {
        super(new ICompositeFXController[0]);
        this.editedReq = editedRequirement;
    }

    public String getFXMLLocation() {
        return "requirement.fxml";
    }

    public void initialize() {
        this.txtId.setText(this.editedReq.getReqId());
        this.txtAuthor.setText(this.editedReq.getAuthor());
        this.txtTitle.setText(this.editedReq.getName());
        this.txtSource.setText(this.editedReq.getSources());
        this.txaDescription.setText(this.editedReq.getDescription());
        this.txaRationale.setText(this.editedReq.getRationale());
        SpinnerValueFactory<RequirementPriority> spvValueFactory = new SpinnerValueFactory<RequirementPriority>(){

            public void decrement(int steps) {
                RequirementPriority oldVal = (RequirementPriority)RequirementController.this.spnPriority.getValue();
                RequirementPriority newVal = RequirementPriority.get((int)(oldVal.getValue() + steps));
                if (newVal != null) {
                    this.setValue(newVal);
                    ICommandStackService.getInstance().runAsCommand((EObject)RequirementController.this.editedReq, () -> RequirementController.this.editedReq.setPriority(newVal));
                }
            }

            public void increment(int steps) {
                RequirementPriority oldVal = (RequirementPriority)RequirementController.this.spnPriority.getValue();
                RequirementPriority newVal = RequirementPriority.get((int)(oldVal.getValue() - steps));
                if (newVal != null) {
                    this.setValue(newVal);
                    ICommandStackService.getInstance().runAsCommand((EObject)RequirementController.this.editedReq, () -> RequirementController.this.editedReq.setPriority(newVal));
                }
            }
        };
        this.spnPriority.setValueFactory((SpinnerValueFactory)spvValueFactory);
        spvValueFactory.setValue((Object)this.editedReq.getPriority());
    }

    @FXML
    protected void onTxtTitleTextChanged() {
        String newTitle = this.txtTitle.getText();
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedReq, () -> this.editedReq.setName(newTitle));
    }

    @FXML
    protected void onTxtIdTextChanged() {
        String newId = this.txtId.getText();
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedReq, () -> this.editedReq.setReqId(newId));
    }

    @FXML
    protected void onTxtAuthorTextChanged() {
        String newAuthor = this.txtAuthor.getText();
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedReq, () -> this.editedReq.setAuthor(newAuthor));
    }

    @FXML
    protected void onTxtSourceTextChanged() {
        String newSource = this.txtSource.getText();
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedReq, () -> this.editedReq.setSources(newSource));
    }

    @FXML
    protected void onTxaDescriptionTextChanged() {
        String newDescr = this.txaDescription.getText();
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedReq, () -> this.editedReq.setDescription(newDescr));
    }

    @FXML
    protected void onTxaRationaleTextChanged() {
        String newTitle = this.txaRationale.getText();
        ICommandStackService.getInstance().runAsCommand((EObject)this.editedReq, () -> this.editedReq.setRationale(newTitle));
    }
}

