/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.mira.ui.editor.contextElement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateListStrategy;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.TextStyledTextActionHandler;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.fortiss.af3.mira.model.Analysis;
import org.fortiss.af3.mira.model.IImageContainer;
import org.fortiss.af3.mira.model.MiraPackage;
import org.fortiss.af3.mira.model.glossary.Glossary;
import org.fortiss.af3.mira.model.glossary.GlossaryEntry;
import org.fortiss.af3.mira.ui.editor.contextElement.ContextElementStringValidator;
import org.fortiss.af3.mira.ui.editor.contextElement.TrimStringConverter;
import org.fortiss.af3.mira.ui.editor.highlight.AnalysisToWordRuleConverter;
import org.fortiss.af3.mira.ui.editor.highlight.ListToWordRuleUpdateStrategy;
import org.fortiss.af3.mira.ui.editor.highlight.ScannerManager;
import org.fortiss.af3.mira.ui.editor.images.ImageSection;
import org.fortiss.af3.mira.ui.utils.HighlightUtils;
import org.fortiss.af3.mira.ui.utils.MiraLayoutUtils;
import org.fortiss.af3.mira.utils.MiraUtils;
import org.fortiss.tooling.base.model.element.ElementPackage;
import org.fortiss.tooling.base.ui.editor.FormsEditorBase;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;
import org.fortiss.tooling.kernel.ui.service.IActionService;
import org.fortiss.tooling.kernel.ui.util.DataBindingUtils;
import org.fortiss.tooling.kernel.ui.util.ObservableUtils;

public class GlossaryEntryEditorBase
extends FormsEditorBase<GlossaryEntry> {
    protected static GridDataFactory singleLineInputFactory = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false);
    protected Analysis analysis;
    protected List<SourceViewer> registeredSourceViewers;
    protected List<Text> registeredTextFields;
    private IChangeListener wordRuleUpdateListener;

    public void dispose() {
        ScannerManager.getScanner(this.analysis).getObservableWordRule().removeChangeListener(this.wordRuleUpdateListener);
        this.wordRuleUpdateListener = null;
        super.dispose();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.analysis = MiraUtils.getAnalysisFor((EObject)this.editedObject);
        this.registeredSourceViewers = new ArrayList<SourceViewer>();
        this.registeredTextFields = new ArrayList<Text>();
        this.createUpdateListener();
    }

    public void registerGlobalActions(IActionBars bars) {
        IActionService.getInstance().registerGlobalUndoRedoActions(bars);
        super.registerGlobalActions(bars);
    }

    protected void addTextStyledText(TextStyledTextActionHandler textStyledTextActionHandler) {
        for (Text text : this.registeredTextFields) {
            textStyledTextActionHandler.addText(text);
        }
        for (SourceViewer sourceViewer : this.registeredSourceViewers) {
            textStyledTextActionHandler.addText(sourceViewer.getTextWidget());
        }
    }

    private void createUpdateListener() {
        this.wordRuleUpdateListener = new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                for (SourceViewer viewer : GlossaryEntryEditorBase.this.registeredSourceViewers) {
                    viewer.refresh();
                }
            }
        };
        ScannerManager.getScanner(this.analysis).getObservableWordRule().addChangeListener(this.wordRuleUpdateListener);
    }

    protected void setupScrolledForm(ScrolledForm form) {
        super.setupScrolledForm(form);
        this.form = form;
        form.setText(this.getTypeUpCase());
    }

    protected String getTypeUpCase() {
        return "Glossary entry";
    }

    protected void createSections() {
        this.createBindings();
        this.createGeneralSection();
        this.createSpecificSection();
    }

    private void createBindings() {
        this.dbc.bindList(ScannerManager.getScanner(this.analysis).getObservableList(), EMFObservables.observeList((EObject)this.analysis, (EStructuralFeature)ElementPackage.Literals.IHIERARCHIC_ELEMENT_CONTAINER__CONTAINED_ELEMENTS), new UpdateListStrategy(UpdateValueStrategy.POLICY_NEVER), new ListToWordRuleUpdateStrategy(this.analysis));
        for (Glossary glossary : this.analysis.getGlossariesList()) {
            this.dbc.bindList(ScannerManager.getScanner(this.analysis).getObservableList(), EMFObservables.observeList((EObject)glossary, (EStructuralFeature)ElementPackage.Literals.IHIERARCHIC_ELEMENT_CONTAINER__CONTAINED_ELEMENTS), new UpdateListStrategy(UpdateValueStrategy.POLICY_NEVER), new ListToWordRuleUpdateStrategy(this.analysis));
        }
    }

    private void createGeneralSection() {
        Composite generalComposite = this.createNewSection("General", "General information");
        generalComposite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = this.toolkit.createLabel(generalComposite, "Name ", 8);
        MiraLayoutUtils.singleLineLabelFactory.applyTo((Control)nameLabel);
        Text nameInput = this.toolkit.createText(generalComposite, "", 2048);
        singleLineInputFactory.applyTo((Control)nameInput);
        nameInput.setData(DataBindingUtils.DECORATION_KEY, (Object)new ControlDecoration((Control)nameInput, 16512));
        this.registeredTextFields.add(nameInput);
        DataBindingUtils.performComplexTextBinding((DataBindingContext)this.dbc, (Control)nameInput, (IObservableValue)ObservableUtils.observeValue((EObject)this.editedObject, (EStructuralFeature)FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME), null, new TrimStringConverter(), new ContextElementStringValidator(), null);
        IObservableValue<WordRule> target = ScannerManager.getScanner(this.analysis).getObservableWordRule();
        IObservableValue model = ObservableUtils.observeValue((EObject)this.editedObject, (EStructuralFeature)FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME);
        this.dbc.bindValue(target, model, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter(new AnalysisToWordRuleConverter(this.analysis)));
        Label definitionLabel = this.toolkit.createLabel(generalComposite, "Definition ", 8);
        MiraLayoutUtils.multiLineLabelFactory.applyTo((Control)definitionLabel);
        SourceViewer defintionInput = HighlightUtils.createSourceViewer(this.form, generalComposite, 2624, this.analysis);
        this.registeredSourceViewers.add(defintionInput);
        MiraLayoutUtils.multiLineInputFactory.applyTo(defintionInput.getControl());
        DataBindingUtils.bind((DataBindingContext)this.dbc, (Control)defintionInput.getTextWidget(), (EObject)this.editedObject, (EStructuralFeature)MiraPackage.Literals.CONTEXT_ELEMENT__DEFINITION);
    }

    protected void createSpecificSection() {
        this.createImageSection();
    }

    private void createImageSection() {
        Composite imageSection = this.createNewSection("Images", "");
        imageSection.setLayout((Layout)new GridLayout(1, false));
        new ImageSection((EditorBase<? extends EObject>)this, imageSection, (IImageContainer)this.editedObject, this.toolkit, (DataBindingContext)this.dbc, this.form, this.registeredSourceViewers);
    }
}

